COLECO:	equ 1
SG1000:	equ 0
MSX:	equ 0
	;
	; CVBasic prologue (BASIC compiler for Colecovision)
	;
	; by Oscar Toledo G.
	; https://nanochess.org/
	;
	; Creation date: Feb/27/2024.
	; Revision date: Feb/29/2024. Turns off sound. Now it reads the controllers.
	;                             Added 16-bit multiply, division, modulo, and abs.
	;                             Added random generator. Added sound routines.
	; Revision date: Mar/03/2024. Removed fname directive to use gasm80.
	; Revision date: Mar/05/2024. Added support for Sega SG1000.
	; Revision date: Mar/06/2024. Added ENASCR, DISSCR, and CPYBLK.
	; Revision date: Mar/08/2024. Added modes 0, 1 and 2.
	; Revision date: Mar/12/2024. Added support for MSX.
	; Revision date: Mar/14/2024. Added _sgn16.
	; Revision date: Mar/15/2024. Added upper 16k enable for MSX.
	;

VDP:    equ $98+$26*COLECO+$26*SG1000
JOYSEL:	equ $c0
KEYSEL:	equ $80

PSG:    equ $ff-$80*SG1000
JOY1:   equ $fc-$20*SG1000
JOY2:   equ $ff-$22*SG1000

BASE_RAM: equ $e000-$7000*COLECO-$2000*SG1000

STACK:	equ $f000-$7c00*COLECO-$2c00*SG1000

    if COLECO
	org $8000
	db $55,$aa
	dw 0
	dw 0
	dw 0
	dw 0
	dw START

	jp 0	; rst $08
	jp 0	; rst $10
	jp 0	; rst $18
	jp 0	; rst $20
	jp 0	; rst $28
	jp 0	; rst $30
	jp 0	; rst $38

	jp nmi_handler
    endif
    if SG1000
	org $0000
	jp START
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp nmi_handler	; It should be called int_handler.
	
	db $ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff

	ei		; NMI handler (pause button)
	retn

    endif
    if MSX
	ORG $4000
	db "AB"
	dw START
	dw $0000
	dw $0000
	dw $0000
	dw $0000
    endif

WRTVDP:
	ld a,b
	out (VDP+1),a
	ld a,c
	or $80
	out (VDP+1),a
	ret

SETWRT:
	ld a,l
	out (VDP+1),a
	ld a,h
	or $40
	out (VDP+1),a
	ret

SETRD:
	ld a,l
	out (VDP+1),a
	ld a,h
        and $3f
	out (VDP+1),a
	ret

WRTVRM:
	push af
	call SETWRT
	pop af
	out (VDP),a
	ret

RDVRM:
        push af
        call SETRD
        pop af
        ex (sp),hl
        ex (sp),hl
        in a,(VDP)
        ret

FILVRM:
	push af
	call SETWRT
.1:	pop af
	out (VDP),a
	push af
	dec bc
	ld a,b
	or c
	jp nz,.1
	pop af
	ret

LDIRVM:
        EX DE,HL
.1:     LD A,(DE)
        CALL WRTVRM
        INC DE
        INC HL
        DEC BC
        LD A,B
        OR C
        JR NZ,.1
        RET

LDIRVM3:
	call .1
	call .1
.1:	push hl
	push de
	push bc
	call LDIRVM
	pop bc
	pop de
	ld a,d
	add a,8
	ld d,a
	pop hl
	ret

DISSCR:
	call nmi_off
	ld bc,$a201
	call WRTVDP
	jp nmi_on

ENASCR:
	call nmi_off
	ld bc,$e201
	call WRTVDP
	jp nmi_on

CPYBLK:
	pop hl
	ex af,af'
	pop af
	ld b,a
	pop af
	ld c,a
	pop de
	ex (sp),hl
	call nmi_off
.1:	push bc
	push hl
	push de
	ld b,0
	call LDIRVM
	pop hl
	ld bc,$0020
	add hl,bc
	ex de,hl
	pop hl
	ex af,af'
	ld c,a
	ld b,0
	add hl,bc
	ex af,af'
	pop bc
	djnz .1
	jp nmi_on
	
nmi_off:
    if COLECO
	push hl
	ld hl,mode
	set 0,(hl)
	pop hl
    endif
    if SG1000+MSX
        di
    endif
	ret

nmi_on:
    if COLECO
	push af
	push hl
	ld hl,mode
	res 0,(hl)
	nop
	bit 1,(hl)
	jp nz,nmi_handler.0
	pop hl
	pop af
    endif
    if SG1000+MSX
        ei
    endif
	ret

    if COLECO
keypad_table:
        db $0f,$08,$04,$05,$0c,$07,$0a,$02
        db $0d,$0b,$00,$09,$03,$01,$06,$0f
    endif

cls:
	ld hl,$1800
	ld (cursor),hl
	ld bc,$0300
	ld a,$20
	call nmi_off
	call FILVRM
	jp nmi_on

print_string:
	ld c,a
	ld b,0
	ld de,(cursor)
	ld a,d
	and $03
	or $18
	ld d,a
	push de
	push bc
	call nmi_off
	call LDIRVM
	call nmi_on
	pop bc
	pop hl
	add hl,bc
	ld (cursor),hl
	ret

print_number:
	ld b,0
	ld de,10000
	call nmi_off
	call .1
	ld de,1000
	call .1
	ld de,100
	call .1
	ld de,10
	call .1
	ld de,1
	inc b
	call .1
	jp nmi_on

.1:	ld a,$2f
	or a
.2:	inc a
	sbc hl,de
	jp nc,.2
	add hl,de
	cp $30
	jr nz,.3
	ld a,b
	or a
	ret z
	ld a,$30
.3:	push hl
	ld hl,(cursor)
	ld c,a
	ld a,h
	and $03
	or $18
	ld h,a
	ld a,c
	call WRTVRM
	inc hl
	ld (cursor),hl
	pop hl
	ld b,1
	ret

define_sprite:
	ex de,hl
	ld l,a
	ld h,0
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	add hl,hl	; x16
	add hl,hl	; x32
	ld c,l
	ld b,h
	pop af
	pop hl
	push af
	add hl,hl	; x2
	add hl,hl	; x4
	ld h,$07
	add hl,hl	; x8
	add hl,hl	; x16
	add hl,hl	; x32
	ex de,hl
	call nmi_off
	call LDIRVM
	jp nmi_on
	
define_char:
	ex de,hl
	ld l,a
	ld h,0
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ld c,l
	ld b,h
	pop af
	pop hl
	push af
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ex de,hl
	call nmi_off
	ld a,(mode)
	and 4
	jr nz,.1
	call LDIRVM3
	jp nmi_on
	
.1:	call LDIRVM
	jp nmi_on

define_color:
	ex de,hl
	ld l,a
	ld h,0
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ld c,l
	ld b,h
	pop af
	pop hl
	push af
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ex de,hl
	set 5,d
	call nmi_off
	call LDIRVM3
	jp nmi_on
	
update_sprite:
	pop bc
	ld (sprite_data+3),a
	pop af
	ld (sprite_data+2),a
	pop af
	ld (sprite_data+1),a
	pop af
	ld (sprite_data),a
	pop af
	push bc
	ld de,sprites
	add a,a
	add a,a
	ld e,a
	ld hl,sprite_data
	ld bc,4
	ldir
	ret

	; Fast 16-bit multiplication.
_mul16:
	ld b,h
	ld c,l
	ld a,16
	ld hl,0
.1:
	srl d
	rr e
	jr nc,.2
	add hl,bc
.2:	sla c
	rl b
	dec a
	jp nz,.1
	ret

	; Fast 16-bit division.
_div16:
	ld b,h
	ld c,l
	ld hl,0
	ld a,16
.1:
	rl c
	rl b
	adc hl,hl
	sbc hl,de
	jp nc,.2	
	add hl,de
.2:
	ccf
	dec a
	jp nz,.1
	rl c
	rl b
	ld h,b
	ld l,c
	ret

	; Fast 16-bit modulo.
_mod16:
	ld b,h
	ld c,l
	ld hl,0
	ld a,16
.1:
	rl c
	rl b
	adc hl,hl
	sbc hl,de
	jp nc,.2	
	add hl,de
.2:
	ccf
	dec a
	jp nz,.1
	ret

_abs16:
	bit 7,h
	ret z
	ld a,h
	cpl
	ld h,a
	ld a,l
	cpl
	ld l,a
	inc hl
	ret

_sgn16:
	ld a,h
	or l
	ret z
	bit 7,h
	ld hl,$ffff
	ret nz
	inc hl
	inc hl
	ret

	; Random number generator.
	; From my game Mecha Eight.
random:
        ld hl,(lfsr)
        ld a,h
        or l
        jr nz,.0
        ld hl,$7811
.0:     ld a,h
        and $80
        ld b,a
        ld a,h
        and $02
        rrca
        rrca
        xor b
        ld b,a
        ld a,h
        and $01
        rrca
        xor b
        ld b,a
        ld a,l
        and $20
        rlca
        rlca
        xor b
        rlca
        rr h
        rr l
        ld (lfsr),hl
        ret

sn76489_freq:
    if COLECO+SG1000
	ld b,a
	ld a,l
	and $0f
	or b
	out (PSG),a
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,hl
	ld a,h
	and $3f
	out (PSG),a
    endif
	ret

sn76489_vol:
    if COLECO+SG1000
	cpl
	and $0f
	or b
	out (PSG),a
    endif
	ret

sn76489_control:
    if COLECO+SG1000
	and $0f
	or $e0
	out (PSG),a
    endif
	ret

ay3_reg:
    if MSX
	ld e,a
	ld a,b
	jp WRTPSG
    else
        ret
    endif

ay3_freq:
    if MSX
	ld e,l
	call WRTPSG
	ld e,h
	inc a
	jp WRTPSG
    else
        ret
    endif

    if SG1000
	; Required for SG1000 as it doesn't have a BIOS
	;
        ; My personal font for TMS9928.
        ;
        ; Patterned after the TMS9928 programming manual 6x8 letters
        ; with better lowercase letters, also I made a proper
        ; AT sign.
        ;
font_bitmaps:
        db $00,$00,$00,$00,$00,$00,$00,$00      ; $20 space
        db $20,$20,$20,$20,$20,$00,$20,$00      ; $21 !
        db $50,$50,$50,$00,$00,$00,$00,$00      ; $22 "
        db $50,$50,$f8,$50,$f8,$50,$50,$00      ; $23 #
        db $20,$78,$a0,$70,$28,$f0,$20,$00      ; $24 $
        db $c0,$c8,$10,$20,$40,$98,$18,$00      ; $25 %
        db $40,$a0,$40,$a0,$a8,$90,$68,$00      ; $26 &
        db $60,$20,$40,$00,$00,$00,$00,$00      ; $27 '
        db $10,$20,$40,$40,$40,$20,$10,$00      ; $28 (
        db $40,$20,$10,$10,$10,$20,$40,$00      ; $29 )
        db $00,$a8,$70,$20,$70,$a8,$00,$00      ; $2a *
        db $00,$20,$20,$f8,$20,$20,$00,$00      ; $2b +
        db $00,$00,$00,$00,$00,$60,$20,$40      ; $2c ,
        db $00,$00,$00,$fc,$00,$00,$00,$00      ; $2d -
        db $00,$00,$00,$00,$00,$00,$60,$00      ; $2e .
        db $00,$08,$10,$20,$40,$80,$00,$00      ; $2f /
        db $70,$88,$98,$a8,$c8,$88,$70,$00      ; $30 0
        db $20,$60,$20,$20,$20,$20,$f8,$00      ; $31 1
        db $70,$88,$08,$10,$60,$80,$f8,$00      ; $32 2
        db $70,$88,$08,$30,$08,$88,$70,$00      ; $33 3
        db $30,$50,$90,$90,$f8,$10,$10,$00      ; $34 4
        db $f8,$80,$f0,$08,$08,$08,$f0,$00      ; $35 5
        db $30,$40,$80,$f0,$88,$88,$70,$00      ; $36 6
        db $f8,$08,$10,$20,$20,$20,$20,$00      ; $37 7
        db $70,$88,$88,$70,$88,$88,$70,$00      ; $38 8
        db $70,$88,$88,$78,$08,$10,$60,$00      ; $39 9
        db $00,$00,$00,$60,$00,$60,$00,$00      ; $3a :
        db $00,$00,$00,$60,$00,$60,$20,$40      ; $3b ;
        db $10,$20,$40,$80,$40,$20,$10,$00      ; $3c <
        db $00,$00,$f8,$00,$f8,$00,$00,$00      ; $3d =
        db $08,$04,$02,$01,$02,$04,$08,$00      ; $3e >
        db $70,$88,$08,$10,$20,$00,$20,$00      ; $3f ?
        db $70,$88,$98,$a8,$98,$80,$70,$00      ; $40 @
        db $20,$50,$88,$88,$f8,$88,$88,$00      ; $41 A
        db $f0,$88,$88,$f0,$88,$88,$f0,$00      ; $42 B
        db $70,$88,$80,$80,$80,$88,$70,$00      ; $43 C
        db $f0,$88,$88,$88,$88,$88,$f0,$00      ; $44 D
        db $f8,$80,$80,$f0,$80,$80,$f8,$00      ; $45 E
        db $f8,$80,$80,$f0,$80,$80,$80,$00      ; $46 F
        db $70,$88,$80,$b8,$88,$88,$70,$00      ; $47 G
        db $88,$88,$88,$f8,$88,$88,$88,$00      ; $48 H
        db $70,$20,$20,$20,$20,$20,$70,$00      ; $49 I
        db $08,$08,$08,$08,$88,$88,$70,$00      ; $4A J
        db $88,$90,$a0,$c0,$a0,$90,$88,$00      ; $4B K
        db $80,$80,$80,$80,$80,$80,$f8,$00      ; $4C L
        db $88,$d8,$a8,$a8,$88,$88,$88,$00      ; $4D M
        db $88,$c8,$c8,$a8,$98,$98,$88,$00      ; $4E N
        db $70,$88,$88,$88,$88,$88,$70,$00      ; $4F O
        db $f0,$88,$88,$f0,$80,$80,$80,$00      ; $50 P
        db $70,$88,$88,$88,$88,$a8,$90,$68      ; $51 Q
        db $f0,$88,$88,$f0,$a0,$90,$88,$00      ; $52 R
        db $70,$88,$80,$70,$08,$88,$70,$00      ; $53 S
        db $f8,$20,$20,$20,$20,$20,$20,$00      ; $54 T
        db $88,$88,$88,$88,$88,$88,$70,$00      ; $55 U
        db $88,$88,$88,$88,$50,$50,$20,$00      ; $56 V
        db $88,$88,$88,$a8,$a8,$d8,$88,$00      ; $57 W
        db $88,$88,$50,$20,$50,$88,$88,$00      ; $58 X
        db $88,$88,$88,$70,$20,$20,$20,$00      ; $59 Y
        db $f8,$08,$10,$20,$40,$80,$f8,$00      ; $5A Z
        db $78,$60,$60,$60,$60,$60,$78,$00      ; $5B [
        db $00,$80,$40,$20,$10,$08,$00,$00      ; $5C \
        db $F0,$30,$30,$30,$30,$30,$F0,$00      ; $5D ]
        db $20,$50,$88,$00,$00,$00,$00,$00      ; $5E 
        db $00,$00,$00,$00,$00,$00,$f8,$00      ; $5F _
        db $40,$20,$10,$00,$00,$00,$00,$00      ; $60 
        db $00,$00,$68,$98,$88,$98,$68,$00      ; $61 a
        db $80,$80,$f0,$88,$88,$88,$f0,$00      ; $62 b
        db $00,$00,$78,$80,$80,$80,$78,$00      ; $63 c
        db $08,$08,$68,$98,$88,$98,$68,$00      ; $64 d
        db $00,$00,$70,$88,$f8,$80,$70,$00      ; $65 e
        db $30,$48,$40,$e0,$40,$40,$40,$00      ; $66 f
        db $00,$00,$78,$88,$88,$78,$08,$70      ; $67 g
        db $80,$80,$f0,$88,$88,$88,$88,$00      ; $68 h
        db $20,$00,$60,$20,$20,$20,$70,$00      ; $69 i
        db $08,$00,$18,$08,$88,$88,$70,$00      ; $6a j
        db $80,$80,$88,$90,$e0,$90,$88,$00      ; $6b k
        db $60,$20,$20,$20,$20,$20,$70,$00      ; $6c l
        db $00,$00,$d0,$a8,$a8,$a8,$a8,$00      ; $6d m
        db $00,$00,$b0,$c8,$88,$88,$88,$00      ; $6e n
        db $00,$00,$70,$88,$88,$88,$70,$00      ; $6f o
        db $00,$00,$f0,$88,$88,$88,$f0,$80      ; $70 p
        db $00,$00,$78,$88,$88,$88,$78,$08      ; $71 q
        db $00,$00,$b8,$c0,$80,$80,$80,$00      ; $72 r
        db $00,$00,$78,$80,$70,$08,$f0,$00      ; $73 s
        db $20,$20,$f8,$20,$20,$20,$20,$00      ; $74 t
        db $00,$00,$88,$88,$88,$98,$68,$00      ; $75 u
        db $00,$00,$88,$88,$88,$50,$20,$00      ; $76 v
        db $00,$00,$88,$a8,$a8,$a8,$50,$00      ; $77 w
        db $00,$00,$88,$50,$20,$50,$88,$00      ; $78 x
        db $00,$00,$88,$88,$98,$68,$08,$70      ; $79 y
        db $00,$00,$f8,$10,$20,$40,$f8,$00      ; $7a z
        db $18,$20,$20,$40,$20,$20,$18,$00      ; $7b {
        db $20,$20,$20,$20,$20,$20,$20,$00      ; $7c |
        db $c0,$20,$20,$10,$20,$20,$c0,$00      ; $7d } 
        db $00,$00,$40,$a8,$10,$00,$00,$00      ; $7e
        db $70,$70,$20,$f8,$20,$70,$50,$00      ; $7f
    endif

mode_0:
	ld hl,mode
	res 2,(hl)
	call nmi_off
	ld bc,$0200
	call WRTVDP
	ld bc,$a201
	call WRTVDP
	ld bc,$0602	; $1800 for pattern table.
	call WRTVDP
	ld bc,$ff03	; $2000 for color table.
	call WRTVDP
	ld bc,$0304	; $0000 for bitmap table.
	call WRTVDP
	ld bc,$3605	; $1b00 for sprite attribute table.
	call WRTVDP
	ld bc,$0706	; $3800 for sprites bitmaps.
	call WRTVDP
	ld bc,$0107
	call WRTVDP
    if COLECO
	ld hl,($006c)
	ld de,-128
	add hl,de
    endif
    if SG1000
	ld hl,font_bitmaps
    endif
    if MSX
	ld hl,($0004)   
	inc h
    endif
	ld de,$0100
	ld bc,$0300
	call LDIRVM3
	call nmi_on
	call nmi_off
	ld hl,$2000
	ld bc,$1800
	ld a,$f1
	call FILVRM
	call nmi_on
	call cls
	call nmi_off
	ld hl,$1b00
	ld bc,$0080
	ld a,$d1
	call FILVRM
	ld hl,sprites
	ld de,sprites+1
	ld bc,127
	ld (hl),$d1
	ldir
	call nmi_on
	call nmi_off
	ld bc,$e201	; Enable screen and interrupts.
	call WRTVDP
	jp nmi_on

mode_1:
	ld hl,mode
	res 2,(hl)
	call nmi_off
	ld bc,$0200
	call WRTVDP
	ld bc,$a201
	call WRTVDP
	ld bc,$0602	; $1800 for pattern table.
	call WRTVDP
	ld bc,$ff03	; $2000 for color table.
	call WRTVDP
	ld bc,$0304	; $0000 for bitmap table.
	call WRTVDP
	ld bc,$3605	; $1b00 for sprite attribute table.
	call WRTVDP
	ld bc,$0706	; $3800 for sprites bitmaps.
	call WRTVDP
	ld bc,$0107
	call WRTVDP
	ld hl,$0000
	ld bc,$1800
	xor a
	call FILVRM
	call nmi_on
	call nmi_off
	ld hl,$2000
	ld bc,$1800
	ld a,$f1
	call FILVRM
	call nmi_on
	ld hl,$1800
.1:	call nmi_off
	ld b,32
.2:	ld a,l
	call WRTVRM
	inc hl
	djnz .2
	call nmi_on
	ld a,h
	cp $1b
	jp nz,.1
	call nmi_off
	ld hl,$1b00
	ld bc,$0080
	ld a,$d1
	call FILVRM
	ld hl,sprites
	ld de,sprites+1
	ld bc,127
	ld (hl),$d1
	ldir
	call nmi_on
	call nmi_off
	ld bc,$e201	; Enable screen and interrupts.
	call WRTVDP
	jp nmi_on

mode_2:
	ld hl,mode
	set 2,(hl)
	call nmi_off
	ld bc,$0000
	call WRTVDP
	ld bc,$a201
	call WRTVDP
	ld bc,$0602	; $1800 for pattern table.
	call WRTVDP
	ld bc,$8003	; $2000 for color table.
	call WRTVDP
	ld bc,$0004	; $0000 for bitmap table.
	call WRTVDP
	ld bc,$3605	; $1b00 for sprite attribute table.
	call WRTVDP
	ld bc,$0706	; $3800 for sprites bitmaps.
	call WRTVDP
	ld bc,$0107
	call WRTVDP
    if COLECO
	ld hl,($006c)
	ld de,-128
	add hl,de
    endif
    if SG1000
	ld hl,font_bitmaps
    endif
    if MSX
	ld hl,($0004)   
	inc h
    endif
	ld de,$0100
	ld bc,$0300
	call LDIRVM
	call nmi_on
	call nmi_off
	ld hl,$2000
	ld bc,$0020
	ld a,$f1
	call FILVRM
	call nmi_on
	call cls
	call nmi_off
	ld hl,$1b00
	ld bc,$0080
	ld a,$d1
	call FILVRM
	ld hl,sprites
	ld de,sprites+1
	ld bc,127
	ld (hl),$d1
	ldir
	call nmi_on
	call nmi_off
	ld bc,$e201	; Enable screen and interrupts.
	call WRTVDP
	jp nmi_on

    if MSX
ENASLT: EQU $0024       ; Select slot (H=Addr, A=Slot)
RSLREG: EQU $0138       ; Read slot status in A

        ;
        ; Get slot mapping
        ; B = 16K bank (0 for $0000, 1 for $4000, 2 for $8000, 3 for $c000)
        ; A = Current slot selection status (CALL RSLREG)
        ;
get_slot_mapping:
        call rotate_slot
        ld c,a
        add a,$C1       ; EXPTBL
        ld l,a
        ld h,$FC
        ld a,(hl)
        and $80         ; Get expanded flag
        or c
        ld c,a
        inc hl
        inc hl
        inc hl
        inc hl
        ld a,(hl)       ; SLTTBL
        call rotate_slot
        rlca
        rlca
        or c            ; A contains bit 7 = Marks expanded
                        ;            bit 6 - 4 = Doesn't care
                        ;            bit 3 - 2 = Secondary mapper
                        ;            bit 1 - 0 = Primary mapper
        ret

rotate_slot:
        push bc
        dec b
        inc b
        jr z,.1
.0:     rrca
        rrca
        djnz .0
.1:     and 3
        pop bc
        ret

    endif

START:
	di
	ld sp,STACK
	in a,(VDP+1)
	ld bc,$8201
	call WRTVDP
	in a,(VDP+1)
	ld bc,$8201
	call WRTVDP

	ld hl,(lfsr)	; Save RAM trash for random generator.
	ld de,BASE_RAM
	xor a
	ld (de),a
	inc de
	bit 2,d
	jp z,$-4
	ld (lfsr),hl

    if COLECO
	ld a,($0069)
	cp 50
	ld a,0
	jr z,$+4
	ld a,1
	ld (ntsc),a
    endif
    if SG1000
	ld a,1
	ld (ntsc),a
    endif
    if MSX
	ld a,($002b)
	cpl
	rlca
	and $01
	ld (ntsc),a

        call RSLREG
        ld b,1          ; $4000-$7fff
        call get_slot_mapping
        ld h,$80
        call ENASLT     ; Map into $8000-$BFFF
    endif

	call music_init

	xor a
	ld (mode),a

	call mode_0

	ld a,$ff
	ld (joy1_data),a
	ld (joy2_data),a
	ld a,$0f
	ld (key1_data),a
	ld (key2_data),a

    if MSX
	ld hl,nmi_handler
	ld ($fd9b),hl
	ld a,$c3
	ld ($fd9a),a
    endif

	; CVBasic program start.
	LD A,3
	LD (music_mode),A
cvb_TITLE_SCREEN:
	CALL mode_1
	CALL DISSCR
	LD HL,0
	PUSH HL
	LD HL,6144
	PUSH HL
	LD HL,cvb_CAMELOT_TITLE_BITMAP
	POP BC
	POP DE
	CALL unpack
	LD HL,8192
	PUSH HL
	LD HL,6144
	PUSH HL
	LD HL,cvb_CAMELOT_TITLE_COLOR
	POP BC
	POP DE
	CALL unpack
	CALL ENASCR
	LD A,4
	LD B,A
	LD C,7
	CALL nmi_off
	CALL WRTVDP
	CALL nmi_on
	LD HL,cvb_MUSIC_TITLE
	CALL music_play
cv1:
	HALT
	CALL random
	LD A,L
	LD (cvb_C),A
	LD A,(joy2_data)
	PUSH AF
	LD A,(joy1_data)
	POP BC
	OR B
	AND A
	JP NZ,cv3
	JP cv1
cv3:
	CALL DISSCR
	LD HL,music_silence
	CALL music_play
	HALT
	HALT
	CALL mode_0
	LD HL,96
	PUSH HL
	LD A,5
	LD HL,cvb_GAME_BITMAPS
	CALL define_char
	LD HL,96
	PUSH HL
	LD A,5
	LD HL,cvb_GAME_COLORS
	CALL define_color
	LD HL,0
	PUSH HL
	LD A,64
	LD HL,cvb_GAME_SPRITES
	CALL define_sprite
	CALL cls
	LD A,3
	LD (cvb_LIVES),A
	LD HL,736
	LD (cursor),HL
	LD HL,cv4
	LD A,6
	CALL print_string
	JP cv5
cv4:
	DB $53,$43,$4f,$52,$45,$3a
cv5:
	LD HL,0
	LD (cvb_#SCORE),HL
	CALL cvb_UPDATE_SCORE
	LD HL,756
	LD (cursor),HL
	LD HL,cv6
	LD A,12
	CALL print_string
	JP cv7
cv6:
	DB $4c,$49,$56,$45,$53,$3a,$20,$60
	DB $20,$60,$20,$60
cv7:
cvb_RESTART_LEVEL:
	LD HL,6304
	LD (cvb_#OFFSET),HL
	LD A,120
	LD (cvb_PLAYER_X),A
	LD A,144
	LD (cvb_PLAYER_Y),A
	SUB A
	LD (cvb_C),A
cv8:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,6
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv8
	LD HL,cvb_MUSIC_GAME
	CALL music_play
	LD A,255
	LD (cvb_SCROLL_MAP),A
cvb_GAME_LOOP:
	HALT
	LD A,(cvb_SCROLL_MAP)
	INC A
	AND 15
	LD (cvb_SCROLL_MAP),A
	AND A
	JP NZ,cv9
	LD HL,(cvb_#OFFSET)
	LD DE,cvb_LEVEL_DATA
	ADD HL,DE
	PUSH HL
	LD HL,6144
	PUSH HL
	LD A,32
	PUSH AF
	LD A,8
	PUSH AF
	LD A,32
	CALL CPYBLK
	LD HL,(cvb_#OFFSET)
	LD DE,256
	ADD HL,DE
	LD DE,cvb_LEVEL_DATA
	ADD HL,DE
	PUSH HL
	LD HL,6400
	PUSH HL
	LD A,32
	PUSH AF
	LD A,8
	PUSH AF
	LD A,32
	CALL CPYBLK
	LD HL,(cvb_#OFFSET)
	LD DE,512
	ADD HL,DE
	LD DE,cvb_LEVEL_DATA
	ADD HL,DE
	PUSH HL
	LD HL,6656
	PUSH HL
	LD A,32
	PUSH AF
	LD A,7
	PUSH AF
	LD A,32
	CALL CPYBLK
	LD HL,(cvb_#OFFSET)
	LD DE,32
	OR A
	SBC HL,DE
	LD (cvb_#OFFSET),HL
	LD HL,(cvb_#OFFSET)
	LD DE,0
	OR A
	SBC HL,DE
	JP NZ,cv10
	JP cvb_BOSS_SECTION
cv10:
cv9:
	LD A,(cvb_NEXT_ENEMY)
	AND A
	JP NZ,cv11
	SUB A
	LD (cvb_C),A
cv12:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	AND A
	JP NZ,cv13
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	LD A,241
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	CALL random
	LD DE,208
	CALL _mod16
	LD A,L
	ADD A,16
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	CALL random
	LD A,L
	AND 1
	INC A
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_S
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
	JP cv14
cv13:
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,2
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv12
cv14:
	CALL random
	LD A,L
	AND 15
	ADD A,16
	LD (cvb_NEXT_ENEMY),A
	JP cv15
cv11:
	LD A,(cvb_NEXT_ENEMY)
	DEC A
	LD (cvb_NEXT_ENEMY),A
cv15:
	SUB A
	LD (cvb_C),A
cv16:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	ADD HL,HL
	LD A,L
	ADD A,4
	LD (cvb_SPR_VDP),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	AND A
	JP NZ,cv17
	LD A,(cvb_SPR_VDP)
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	LD A,(cvb_SPR_VDP)
	INC A
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	JP cv18
cv17:
	LD HL,(frame)
	LD A,L
	AND 8
	LD L,A
	LD H,0
	SRL H
	RR L
	LD A,L
	ADD A,32
	LD (cvb_SPR_FRAME),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	CP 1
	JP NZ,cv19
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	CP 32
	JP C,cv20
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_PLAYER_X)
	POP BC
	CP B
	JP NC,cv21
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	DEC A
	POP HL
	LD (HL),A
	JP cv22
cv21:
	LD A,(cvb_PLAYER_X)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	POP BC
	CP B
	JP NC,cv23
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	INC A
	POP HL
	LD (HL),A
cv22:
cv23:
cv20:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	INC A
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	CP 176
	JP NZ,cv24
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
cv24:
	LD A,(cvb_SPR_VDP)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_SPR_FRAME)
	PUSH AF
	LD A,8
	CALL update_sprite
	LD A,(cvb_SPR_VDP)
	INC A
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_SPR_FRAME)
	ADD A,16
	PUSH AF
	LD A,15
	CALL update_sprite
	JP cv25
cv19:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_S
	ADD HL,DE
	LD A,(HL)
	CP 32
	JP NC,cv26
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	INC A
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_S
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_S
	ADD HL,DE
	LD A,(HL)
	INC A
	POP HL
	LD (HL),A
	JP cv27
cv26:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_S
	ADD HL,DE
	LD A,(HL)
	CP 160
	JP NC,cv28
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_S
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	LD DE,32
	OR A
	SBC HL,DE
	LD DE,cvb_CIRCLE_X
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	POP BC
	ADD A,B
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_S
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	LD DE,32
	OR A
	SBC HL,DE
	LD DE,cvb_CIRCLE_Y
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	POP BC
	ADD A,B
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_S
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_S
	ADD HL,DE
	LD A,(HL)
	INC A
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_S
	ADD HL,DE
	LD A,(HL)
	CP 63
	JP NZ,cv29
	LD A,(cvb_C)
	LD L,A
	LD H,0
	INC HL
	INC HL
	INC HL
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	AND A
	JP NZ,cv30
	LD A,(cvb_C)
	LD L,A
	LD H,0
	INC HL
	INC HL
	INC HL
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	LD A,10
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	INC HL
	INC HL
	INC HL
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	INC HL
	INC HL
	INC HL
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_PLAYER_X)
	POP BC
	CP B
	JP NC,cv31
	LD A,(cvb_C)
	LD L,A
	LD H,0
	INC HL
	INC HL
	INC HL
	LD DE,array_ENEMY_D
	ADD HL,DE
	PUSH HL
	LD A,255
	POP HL
	LD (HL),A
	JP cv32
cv31:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	INC HL
	INC HL
	INC HL
	LD DE,array_ENEMY_D
	ADD HL,DE
	PUSH HL
	LD A,1
	POP HL
	LD (HL),A
cv32:
	LD A,2
	LD (cvb_SOUND_EFFECT),A
	SUB A
	LD (cvb_SOUND_STATE),A
cv30:
cv29:
	JP cv27
cv28:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_PLAYER_X)
	POP BC
	CP B
	JP NC,cv33
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	DEC A
	POP HL
	LD (HL),A
	JP cv34
cv33:
	LD A,(cvb_PLAYER_X)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	POP BC
	CP B
	JP NC,cv35
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	INC A
	POP HL
	LD (HL),A
cv34:
cv35:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	INC A
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	CP 176
	JP NZ,cv36
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
cv36:
cv27:
	LD A,(cvb_SPR_VDP)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_SPR_FRAME)
	ADD A,8
	PUSH AF
	LD A,13
	CALL update_sprite
	LD A,(cvb_SPR_VDP)
	INC A
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_SPR_FRAME)
	ADD A,24
	PUSH AF
	LD A,15
	CALL update_sprite
cv25:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	LD (cvb_#BX),HL
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	LD (cvb_#BY),HL
	LD A,(cvb_PLAYER_X)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,(cvb_#BX)
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv37
	LD A,(cvb_PLAYER_Y)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,(cvb_#BY)
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv38
	JP cvb_PLAYER_DIES
cv38:
cv37:
cv18:
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,2
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv16
	CALL cvb_MOVE_SHOTS
	LD A,(cvb_PLAYER_HIT)
	OR A
	JP Z,cv39
	JP cvb_PLAYER_DIES
cv39:
	CALL cvb_MOVE_PLAYER
	JP cvb_GAME_LOOP
cvb_BOSS_SECTION:
	LD HL,cvb_MUSIC_BOSS
	CALL music_play
	LD A,4
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	LD A,5
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	LD A,6
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	LD A,7
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	LD A,8
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	LD A,9
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	SUB A
	LD (cvb_C),A
cv40:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,2
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv40
	LD A,120
	LD (cvb_BOSS_X),A
	SUB A
	LD (cvb_BOSS_Y),A
	LD A,1
	LD (cvb_BOSS_DIR),A
	SUB A
	LD (cvb_BOSS_HITS),A
	LD A,8
	LD (cvb_BOSS_COLOR),A
	SUB A
	LD (cvb_COUNT),A
cv41:
	HALT
	CALL cvb_DRAW_BOSS
	CALL cvb_MOVE_SHOTS
	LD A,(cvb_PLAYER_HIT)
	OR A
	JP Z,cv42
	JP cvb_PLAYER_DIES
cv42:
	CALL cvb_MOVE_PLAYER
	HALT
	CALL cvb_DRAW_BOSS
	CALL cvb_MOVE_SHOTS
	LD A,(cvb_PLAYER_HIT)
	OR A
	JP Z,cv43
	JP cvb_PLAYER_DIES
cv43:
	CALL cvb_MOVE_PLAYER
	LD A,(cvb_BOSS_Y)
	INC A
	LD (cvb_BOSS_Y),A
	LD A,(cvb_COUNT)
	INC A
	LD (cvb_COUNT),A
	PUSH AF
	LD A,32
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv41
cvb_BOSS_LOOP:
	HALT
	LD HL,(frame)
	LD A,L
	AND 1
	LD L,A
	LD H,0
	LD A,H
	OR L
	JP Z,cv44
	LD A,(cvb_BOSS_DIR)
	CP 1
	JP NZ,cv45
	LD A,(cvb_BOSS_X)
	DEC A
	LD (cvb_BOSS_X),A
	LD L,A
	LD H,0
	LD A,L
	AND 7
	LD L,A
	LD H,0
	LD DE,cvb_BOSS_OSCILLATE
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_BOSS_Y)
	POP BC
	ADD A,B
	LD (cvb_BOSS_Y),A
	LD A,(cvb_BOSS_X)
	CP 16
	JP NZ,cv46
	SUB A
	LD (cvb_BOSS_DIR),A
cv46:
	JP cv47
cv45:
	LD A,(cvb_BOSS_X)
	INC A
	LD (cvb_BOSS_X),A
	LD L,A
	LD H,0
	LD A,L
	AND 7
	LD L,A
	LD H,0
	LD DE,cvb_BOSS_OSCILLATE
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_BOSS_Y)
	POP BC
	ADD A,B
	LD (cvb_BOSS_Y),A
	LD A,(cvb_BOSS_X)
	CP 208
	JP NZ,cv48
	LD A,1
	LD (cvb_BOSS_DIR),A
cv48:
cv47:
cv44:
	CALL random
	LD A,L
	AND 7
	LD L,A
	LD H,0
	LD DE,0
	OR A
	SBC HL,DE
	JP NZ,cv49
	LD A,3
	LD (cvb_C),A
cv50:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	AND A
	JP NZ,cv51
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	LD A,7
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	LD A,(cvb_BOSS_X)
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	LD A,(cvb_BOSS_Y)
	ADD A,8
	POP HL
	LD (HL),A
	LD A,(cvb_BOSS_X)
	PUSH AF
	LD A,(cvb_PLAYER_X)
	POP BC
	CP B
	JP NC,cv52
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_D
	ADD HL,DE
	PUSH HL
	LD A,255
	POP HL
	LD (HL),A
	JP cv53
cv52:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_D
	ADD HL,DE
	PUSH HL
	LD A,1
	POP HL
	LD (HL),A
cv53:
	LD A,2
	LD (cvb_SOUND_EFFECT),A
	SUB A
	LD (cvb_SOUND_STATE),A
	JP cv54
cv51:
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,5
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv50
cv54:
cv49:
	LD HL,6
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	OR A
	JP Z,cv55
	LD HL,6
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	PUSH HL
	LD A,(cvb_BOSS_X)
	LD L,A
	LD H,0
	INC HL
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv56
	LD HL,6
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	PUSH HL
	LD A,(cvb_BOSS_Y)
	LD L,A
	LD H,0
	INC HL
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv57
	LD HL,6
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
	LD A,3
	LD (cvb_SOUND_EFFECT),A
	SUB A
	LD (cvb_SOUND_STATE),A
	LD A,(cvb_BOSS_HITS)
	INC A
	LD (cvb_BOSS_HITS),A
	CP 10
	JP NZ,cv58
	JP cvb_BOSS_DEFEATED
cv58:
cv57:
cv56:
cv55:
	LD A,8
	LD (cvb_BOSS_COLOR),A
	LD A,(cvb_SOUND_EFFECT)
	CP 3
	JP NZ,cv59
	LD A,10
	LD (cvb_BOSS_COLOR),A
cv59:
	CALL cvb_DRAW_BOSS
	CALL cvb_MOVE_SHOTS
	LD A,(cvb_PLAYER_HIT)
	OR A
	JP Z,cv60
	JP cvb_PLAYER_DIES
cv60:
	CALL cvb_MOVE_PLAYER
	JP cvb_BOSS_LOOP
cvb_BOSS_DEFEATED:
	LD A,5
	LD (cvb_SOUND_EFFECT),A
	SUB A
	LD (cvb_SOUND_STATE),A
	SUB A
	LD (cvb_C),A
cv61:
	HALT
	LD HL,(frame)
	LD A,L
	AND 3
	LD (cvb_D),A
	AND A
	JP NZ,cv62
	LD A,4
	LD (cvb_BOSS_COLOR),A
cv62:
	LD A,(cvb_D)
	CP 1
	JP NZ,cv63
	LD A,10
	LD (cvb_BOSS_COLOR),A
cv63:
	LD A,(cvb_D)
	CP 2
	JP NZ,cv64
	LD A,15
	LD (cvb_BOSS_COLOR),A
cv64:
	LD A,(cvb_D)
	CP 3
	JP NZ,cv65
	LD A,10
	LD (cvb_BOSS_COLOR),A
cv65:
	CALL cvb_DRAW_BOSS
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,120
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv61
	LD HL,(cvb_#SCORE)
	LD DE,1000
	ADD HL,DE
	LD (cvb_#SCORE),HL
	CALL cvb_UPDATE_SCORE
	LD A,4
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	LD A,5
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	LD A,6
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	LD A,7
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	LD A,8
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	LD HL,music_silence
	CALL music_play
	SUB A
	LD (cvb_C),A
cv66:
	HALT
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,120
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv66
	JP cvb_GAME_WON
cvb_BOSS_OSCILLATE:
	DB $ff
	DB $ff
	DB $ff
	DB $00
	DB $00
	DB $01
	DB $01
	DB $01
cvb_ENEMY_COLORS:
	DB $0a
	DB $0a
	DB $0a
	DB $0a
	DB $0b
	DB $0b
	DB $0e
	DB $0e
	DB $06
	DB $0a
	DB $0f
	DB $0e
	DB $0f
	DB $0f
	DB $0d
	DB $0f
cvb_CIRCLE_X:
	DB $00
	DB $01
	DB $02
	DB $01
	DB $02
	DB $01
	DB $01
	DB $02
	DB $01
	DB $01
	DB $01
	DB $01
	DB $00
	DB $01
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $ff
	DB $00
	DB $ff
	DB $ff
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $ff
	DB $ff
	DB $00
	DB $ff
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $01
	DB $00
	DB $01
	DB $01
	DB $01
	DB $01
	DB $02
	DB $01
	DB $01
	DB $02
	DB $01
	DB $02
	DB $01
	DB $01
	DB $02
	DB $01
	DB $02
	DB $01
	DB $01
	DB $02
	DB $01
	DB $01
	DB $01
	DB $01
	DB $00
	DB $01
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $ff
	DB $00
	DB $ff
	DB $ff
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $ff
	DB $ff
	DB $00
	DB $ff
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $01
	DB $00
	DB $01
	DB $01
	DB $01
	DB $01
	DB $02
	DB $01
	DB $01
	DB $02
	DB $01
	DB $02
cvb_CIRCLE_Y:
	DB $00
	DB $01
	DB $00
	DB $00
	DB $01
	DB $00
	DB $01
	DB $01
	DB $01
	DB $01
	DB $02
	DB $01
	DB $01
	DB $02
	DB $01
	DB $02
	DB $01
	DB $01
	DB $02
	DB $01
	DB $02
	DB $01
	DB $01
	DB $02
	DB $01
	DB $01
	DB $01
	DB $01
	DB $00
	DB $01
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $ff
	DB $00
	DB $ff
	DB $ff
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $ff
	DB $ff
	DB $00
	DB $ff
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $01
	DB $00
	DB $01
	DB $01
	DB $01
	DB $01
	DB $02
	DB $01
	DB $01
	DB $02
	DB $01
	DB $02
	DB $01
	DB $01
	DB $02
	DB $01
	DB $02
	DB $01
	DB $01
	DB $02
	DB $01
	DB $01
	DB $01
	DB $01
	DB $00
	DB $01
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $ff
	DB $00
	DB $ff
	DB $ff
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $fe
	DB $ff
	DB $ff
	DB $ff
	DB $ff
	DB $00
	DB $ff
	DB $00
	DB $00
cvb_PLAYER_DIES:
	LD HL,music_silence
	CALL music_play
	LD A,4
	LD (cvb_SOUND_EFFECT),A
	SUB A
	LD (cvb_SOUND_STATE),A
	SUB A
	LD (cvb_C),A
cv67:
	HALT
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,30
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv67
	LD A,76
	LD (cvb_PLAYER_FRAME),A
	SUB A
	PUSH AF
	LD A,(cvb_PLAYER_Y)
	PUSH AF
	LD A,(cvb_PLAYER_X)
	PUSH AF
	LD A,(cvb_PLAYER_FRAME)
	PUSH AF
	LD A,1
	CALL update_sprite
	LD A,1
	PUSH AF
	LD A,(cvb_PLAYER_Y)
	PUSH AF
	LD A,(cvb_PLAYER_X)
	PUSH AF
	LD A,(cvb_PLAYER_FRAME)
	ADD A,16
	PUSH AF
	LD A,15
	CALL update_sprite
	LD A,2
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	LD A,3
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	LD A,4
	LD (cvb_C),A
cv68:
	LD A,(cvb_C)
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,31
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv68
	SUB A
	LD (cvb_C),A
cv69:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,6
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv69
	SUB A
	LD (cvb_C),A
cv70:
	HALT
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,60
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv70
	LD A,(cvb_LIVES)
	AND A
	JP NZ,cv71
	LD HL,330
	LD (cursor),HL
	LD HL,cv72
	LD A,11
	CALL print_string
	JP cv73
cv72:
	DB $20,$47,$41,$4d,$45,$20,$4f,$56
	DB $45,$52,$20
cv73:
	SUB A
	LD (cvb_C),A
cv74:
	HALT
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,240
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv74
	JP cvb_TITLE_SCREEN
cv71:
	LD A,(cvb_LIVES)
	DEC A
	LD (cvb_LIVES),A
	LD L,A
	LD H,0
	ADD HL,HL
	LD DE,763
	ADD HL,DE
	LD (cursor),HL
	LD HL,cv75
	LD A,1
	CALL print_string
	JP cv76
cv75:
	DB $20
cv76:
	JP cvb_RESTART_LEVEL
cvb_GAME_WON:
	LD A,72
	LD (cvb_PLAYER_FRAME),A
	SUB A
	PUSH AF
	LD A,(cvb_PLAYER_Y)
	PUSH AF
	LD A,(cvb_PLAYER_X)
	PUSH AF
	LD A,(cvb_PLAYER_FRAME)
	PUSH AF
	LD A,1
	CALL update_sprite
	LD A,1
	PUSH AF
	LD A,(cvb_PLAYER_Y)
	PUSH AF
	LD A,(cvb_PLAYER_X)
	PUSH AF
	LD A,(cvb_PLAYER_FRAME)
	ADD A,16
	PUSH AF
	LD A,15
	CALL update_sprite
	LD A,2
	PUSH AF
	LD A,(cvb_PLAYER_Y)
	PUSH AF
	LD A,(cvb_PLAYER_X)
	PUSH AF
	LD A,(cvb_PLAYER_FRAME)
	ADD A,32
	PUSH AF
	LD A,7
	CALL update_sprite
	LD A,3
	PUSH AF
	LD A,(cvb_PLAYER_Y)
	PUSH AF
	LD A,(cvb_PLAYER_X)
	PUSH AF
	LD A,(cvb_PLAYER_FRAME)
	ADD A,36
	PUSH AF
	LD A,9
	CALL update_sprite
	LD HL,331
	LD (cursor),HL
	LD HL,cv77
	LD A,10
	CALL print_string
	JP cv78
cv77:
	DB $20,$59,$4f,$55,$20,$57,$49,$4e
	DB $21,$20
cv78:
	SUB A
	LD (cvb_C),A
cv79:
	HALT
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,240
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv79
	JP cvb_TITLE_SCREEN
cvb_UPDATE_SCORE:
	LD HL,742
	LD (cursor),HL
	LD HL,(cvb_#SCORE)
	CALL print_number
	RET
cvb_DRAW_BOSS:
	LD HL,(frame)
	LD A,L
	AND 8
	LD L,A
	LD H,0
	LD A,H
	OR L
	JP Z,cv80
	LD A,128
	LD (cvb_BOSS_FRAME),A
	JP cv81
cv80:
	LD A,144
	LD (cvb_BOSS_FRAME),A
cv81:
	LD A,4
	PUSH AF
	LD A,(cvb_BOSS_Y)
	SUB 8
	PUSH AF
	LD A,(cvb_BOSS_X)
	SUB 8
	PUSH AF
	LD A,(cvb_BOSS_FRAME)
	PUSH AF
	LD A,(cvb_BOSS_COLOR)
	CALL update_sprite
	LD A,5
	PUSH AF
	LD A,(cvb_BOSS_Y)
	SUB 8
	PUSH AF
	LD A,(cvb_BOSS_X)
	ADD A,8
	PUSH AF
	LD A,(cvb_BOSS_FRAME)
	ADD A,4
	PUSH AF
	LD A,(cvb_BOSS_COLOR)
	CALL update_sprite
	LD A,6
	PUSH AF
	LD A,(cvb_BOSS_Y)
	ADD A,8
	PUSH AF
	LD A,(cvb_BOSS_X)
	SUB 8
	PUSH AF
	LD A,(cvb_BOSS_FRAME)
	ADD A,8
	PUSH AF
	LD A,(cvb_BOSS_COLOR)
	CALL update_sprite
	LD A,7
	PUSH AF
	LD A,(cvb_BOSS_Y)
	ADD A,8
	PUSH AF
	LD A,(cvb_BOSS_X)
	ADD A,8
	PUSH AF
	LD A,(cvb_BOSS_FRAME)
	ADD A,12
	PUSH AF
	LD A,(cvb_BOSS_COLOR)
	CALL update_sprite
	LD A,(cvb_BOSS_FRAME)
	CP 128
	JP NZ,cv82
	LD A,8
	PUSH AF
	LD A,(cvb_BOSS_Y)
	PUSH AF
	LD A,(cvb_BOSS_X)
	PUSH AF
	LD A,112
	PUSH AF
	LD A,1
	CALL update_sprite
	JP cv83
cv82:
	LD A,8
	PUSH AF
	LD A,(cvb_BOSS_Y)
	PUSH AF
	LD A,(cvb_BOSS_X)
	PUSH AF
	LD A,116
	PUSH AF
	LD A,1
	CALL update_sprite
cv83:
	RET
cvb_MOVE_SHOTS:
	SUB A
	LD (cvb_PLAYER_HIT),A
	LD A,3
	LD (cvb_C),A
cv84:
	LD A,(cvb_C)
	SUB 249
	LD (cvb_SPR_VDP),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	AND A
	JP NZ,cv85
	LD A,(cvb_SPR_VDP)
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	JP cv86
cv85:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	DEC HL
	DEC HL
	DEC HL
	ADD HL,HL
	LD A,L
	LD (cvb_D),A
	LD HL,(frame)
	LD A,L
	AND 4
	LD L,A
	LD H,0
	LD A,H
	OR L
	JP Z,cv87
	LD A,(cvb_D)
	INC A
	LD (cvb_D),A
cv87:
	LD A,(cvb_D)
	LD L,A
	LD H,0
	LD DE,cvb_ENEMY_COLORS
	ADD HL,DE
	LD A,(HL)
	LD (cvb_E),A
	LD A,(cvb_SPR_VDP)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	DEC HL
	DEC HL
	DEC HL
	ADD HL,HL
	ADD HL,HL
	LD A,L
	PUSH AF
	LD A,(cvb_E)
	CALL update_sprite
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	CP 7
	JP NZ,cv88
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	ADD A,2
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_D
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	POP BC
	ADD A,B
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	CP 255
	LD A,0
	JR NZ,$+3
	DEC A
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	AND A
	LD A,0
	JR NZ,$+3
	DEC A
	POP BC
	ADD A,B
	OR A
	JP Z,cv89
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
cv89:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	LD (cvb_#BX),HL
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	LD (cvb_#BY),HL
	LD A,(cvb_PLAYER_X)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,(cvb_#BX)
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv90
	LD A,(cvb_PLAYER_Y)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,(cvb_#BY)
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv91
	LD A,1
	LD (cvb_PLAYER_HIT),A
cv91:
cv90:
	JP cv92
cv88:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	CP 8
	JP NZ,cv93
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	INC A
	POP HL
	LD (HL),A
	JP cv92
cv93:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	CP 9
	JP NZ,cv94
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	CP 4
	JP NC,cv95
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
cv95:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	SUB 4
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	LD (cvb_#BX),HL
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	LD (cvb_#BY),HL
	SUB A
	LD (cvb_D),A
cv96:
	LD A,(cvb_D)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,(cvb_#BX)
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv97
	LD A,(cvb_D)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,(cvb_#BY)
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv98
	LD A,(cvb_D)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	CP 2
	LD A,0
	JR NZ,$+3
	DEC A
	PUSH AF
	LD A,(cvb_D)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	CP 1
	LD A,0
	JR NZ,$+3
	DEC A
	POP BC
	ADD A,B
	OR A
	JP Z,cv99
	LD A,(cvb_D)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	CP 1
	JP NZ,cv100
	LD HL,(cvb_#SCORE)
	LD DE,50
	ADD HL,DE
	LD (cvb_#SCORE),HL
	JP cv101
cv100:
	LD HL,(cvb_#SCORE)
	LD DE,75
	ADD HL,DE
	LD (cvb_#SCORE),HL
cv101:
	CALL cvb_UPDATE_SCORE
	LD A,3
	LD (cvb_SOUND_EFFECT),A
	SUB A
	LD (cvb_SOUND_STATE),A
	LD A,(cvb_D)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	LD A,3
	POP HL
	LD (HL),A
cv99:
cv98:
cv97:
	LD A,(cvb_D)
	INC A
	LD (cvb_D),A
	PUSH AF
	LD A,2
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv96
	JP cv92
cv94:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	CP 10
	JP NZ,cv102
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	ADD A,2
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_D
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	POP BC
	ADD A,B
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	CP 255
	LD A,0
	JR NZ,$+3
	DEC A
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	AND A
	LD A,0
	JR NZ,$+3
	DEC A
	POP BC
	ADD A,B
	OR A
	JP Z,cv103
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
cv103:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	LD (cvb_#BX),HL
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	LD (cvb_#BY),HL
	LD A,(cvb_PLAYER_X)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,(cvb_#BX)
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv104
	LD A,(cvb_PLAYER_Y)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,(cvb_#BY)
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv105
	LD A,1
	LD (cvb_PLAYER_HIT),A
cv105:
cv104:
	JP cv92
cv102:
	LD HL,(frame)
	LD A,L
	AND 3
	LD L,A
	LD H,0
	LD DE,0
	OR A
	SBC HL,DE
	JP NZ,cv106
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	INC A
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	CP 7
	JP NZ,cv107
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
cv107:
cv106:
cv92:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	CP 176
	JP C,cv108
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
cv108:
cv86:
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,6
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv84
	RET
cvb_MOVE_PLAYER:
	LD A,(joy2_data)
	PUSH AF
	LD A,(joy1_data)
	POP BC
	OR B
	AND 1
	JP Z,cv109
	LD A,(cvb_PLAYER_Y)
	PUSH AF
	LD A,96
	POP BC
	CP B
	JP NC,cv110
	LD A,(cvb_PLAYER_Y)
	DEC A
	LD (cvb_PLAYER_Y),A
cv110:
cv109:
	LD A,(joy2_data)
	PUSH AF
	LD A,(joy1_data)
	POP BC
	OR B
	AND 4
	JP Z,cv111
	LD A,(cvb_PLAYER_Y)
	CP 144
	JP NC,cv112
	INC A
	LD (cvb_PLAYER_Y),A
cv112:
cv111:
	LD A,(joy2_data)
	PUSH AF
	LD A,(joy1_data)
	POP BC
	OR B
	AND 8
	JP Z,cv113
	LD A,(cvb_PLAYER_X)
	PUSH AF
	SUB A
	POP BC
	CP B
	JP NC,cv114
	LD A,(cvb_PLAYER_X)
	DEC A
	LD (cvb_PLAYER_X),A
cv114:
cv113:
	LD A,(joy2_data)
	PUSH AF
	LD A,(joy1_data)
	POP BC
	OR B
	AND 2
	JP Z,cv115
	LD A,(cvb_PLAYER_X)
	CP 240
	JP NC,cv116
	INC A
	LD (cvb_PLAYER_X),A
cv116:
cv115:
	LD A,(joy2_data)
	PUSH AF
	LD A,(joy1_data)
	POP BC
	OR B
	AND 64
	JP Z,cv117
	LD HL,6
	LD DE,array_ENEMY_T
	ADD HL,DE
	LD A,(HL)
	AND A
	JP NZ,cv118
	LD HL,6
	LD DE,array_ENEMY_T
	ADD HL,DE
	PUSH HL
	LD A,9
	POP HL
	LD (HL),A
	LD HL,6
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	LD A,(cvb_PLAYER_X)
	POP HL
	LD (HL),A
	LD HL,6
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	LD A,(cvb_PLAYER_Y)
	SUB 8
	POP HL
	LD (HL),A
	LD A,1
	LD (cvb_SOUND_EFFECT),A
	SUB A
	LD (cvb_SOUND_STATE),A
cv118:
cv117:
	LD HL,(frame)
	LD A,L
	AND 8
	LD L,A
	LD H,0
	LD A,H
	OR L
	JP Z,cv119
	LD A,64
	LD (cvb_PLAYER_FRAME),A
	JP cv120
cv119:
	LD A,68
	LD (cvb_PLAYER_FRAME),A
cv120:
	SUB A
	PUSH AF
	LD A,(cvb_PLAYER_Y)
	PUSH AF
	LD A,(cvb_PLAYER_X)
	PUSH AF
	LD A,(cvb_PLAYER_FRAME)
	PUSH AF
	LD A,1
	CALL update_sprite
	LD A,1
	PUSH AF
	LD A,(cvb_PLAYER_Y)
	PUSH AF
	LD A,(cvb_PLAYER_X)
	PUSH AF
	LD A,(cvb_PLAYER_FRAME)
	ADD A,16
	PUSH AF
	LD A,15
	CALL update_sprite
	LD A,2
	PUSH AF
	LD A,(cvb_PLAYER_Y)
	PUSH AF
	LD A,(cvb_PLAYER_X)
	PUSH AF
	LD A,(cvb_PLAYER_FRAME)
	ADD A,32
	PUSH AF
	LD A,7
	CALL update_sprite
	LD A,3
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	RET
cvb_GAME_BITMAPS:
	DB $3c,$3c,$3c,$99,$ff,$3c,$66,$e7
	DB $ff,$df,$ff,$fb,$ff,$ff,$ef,$ff
	DB $00,$0c,$00,$60,$10,$00,$81,$02
	DB $df,$fb,$7f,$fd,$ef,$fe,$bf,$f7
	DB $9f,$ff,$ff,$06,$99,$ff,$ff,$60
cvb_GAME_COLORS:
	DB $91
	DB $91
	DB $91
	DB $91
	DB $e1
	DB $e1
	DB $e1
	DB $e1
	DB $c1
	DB $c1
	DB $c1
	DB $c1
	DB $c1
	DB $c1
	DB $c1
	DB $c1
	DB $14
	DB $14
	DB $14
	DB $14
	DB $14
	DB $14
	DB $14
	DB $14
	DB $c1
	DB $c1
	DB $c1
	DB $c1
	DB $c1
	DB $c1
	DB $c1
	DB $c1
	DB $61
	DB $61
	DB $61
	DB $61
	DB $61
	DB $61
	DB $61
	DB $61
cvb_LEVEL_DATA:
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	CALL mode_1
	CALL DISSCR
	LD HL,0
	PUSH HL
	LD HL,6144
	PUSH HL
	LD HL,cvb_CAMELOT_TITLE_BITMAP
	POP BC
	POP DE
	CALL unpack
	LD HL,8192
	PUSH HL
	LD HL,6144
	PUSH HL
	LD HL,cvb_CAMELOT_TITLE_COLOR
	POP BC
	POP DE
	CALL unpack
	CALL ENASCR
cv121:
	JP cv121
cv122:
cvb_CAMELOT_TITLE_BITMAP:
	DB $7a
	DB $ff
	DB $ab
	DB $80
	DB $00
	DB $03
	DB $0f
	DB $3f
	DB $ff
	DB $07
	DB $40
	DB $1f
	DB $03
	DB $fe
	DB $f8
	DB $e0
	DB $c0
	DB $f8
	DB $1e
	DB $f0
	DB $c0
	DB $ff
	DB $ff
	DB $c8
	DB $00
	DB $01
	DB $ec
	DB $1c
	DB $7f
	DB $f3
	DB $11
	DB $00
	DB $fc
	DB $f0
	DB $40
	DB $02
	DB $f4
	DB $80
	DB $cd
	DB $08
	DB $9f
	DB $19
	DB $00
	DB $35
	DB $22
	DB $1f
	DB $02
	DB $2c
	DB $f8
	DB $e7
	DB $cf
	DB $8f
	DB $00
	DB $06
	DB $cf
	DB $ff
	DB $3f
	DB $df
	DB $ef
	DB $6f
	DB $00
	DB $bb
	DB $06
	DB $f0
	DB $07
	DB $ec
	DB $06
	DB $f3
	DB $31
	DB $09
	DB $fe
	DB $02
	DB $fc
	DB $14
	DB $e2
	DB $f1
	DB $1c
	DB $f4
	DB $08
	DB $fe
	DB $ec
	DB $88
	DB $e0
	DB $f0
	DB $08
	DB $40
	DB $40
	DB $03
	DB $c0
	DB $20
	DB $a0
	DB $01
	DB $01
	DB $00
	DB $48
	DB $00
	DB $15
	DB $7f
	DB $3f
	DB $22
	DB $1f
	DB $0f
	DB $07
	DB $ef
	DB $df
	DB $00
	DB $20
	DB $de
	DB $9c
	DB $07
	DB $c7
	DB $c7
	DB $87
	DB $87
	DB $0d
	DB $07
	DB $0f
	DB $0f
	DB $1f
	DB $df
	DB $e2
	DB $e0
	DB $c0
	DB $f3
	DB $83
	DB $f0
	DB $ce
	DB $0e
	DB $e2
	DB $2c
	DB $da
	DB $4f
	DB $9c
	DB $1c
	DB $03
	DB $cf
	DB $06
	DB $c0
	DB $7c
	DB $c0
	DB $0d
	DB $e0
	DB $e0
	DB $60
	DB $c0
	DB $90
	DB $00
	DB $a0
	DB $50
	DB $b0
	DB $f0
	DB $f8
	DB $7c
	DB $3e
	DB $1f
	DB $9c
	DB $17
	DB $07
	DB $83
	DB $25
	DB $80
	DB $d0
	DB $17
	DB $82
	DB $06
	DB $01
	DB $1b
	DB $0f
	DB $07
	DB $5a
	DB $3f
	DB $44
	DB $af
	DB $c4
	DB $00
	DB $fc
	DB $07
	DB $b6
	DB $1c
	DB $87
	DB $56
	DB $04
	DB $b8
	DB $e0
	DB $5c
	DB $f3
	DB $1c
	DB $d1
	DB $9c
	DB $ae
	DB $1c
	DB $e2
	DB $56
	DB $2d
	DB $16
	DB $d9
	DB $b9
	DB $44
	DB $51
	DB $24
	DB $00
	DB $fe
	DB $01
	DB $83
	DB $80
	DB $fa
	DB $e5
	DB $d7
	DB $4f
	DB $4f
	DB $2f
	DB $01
	DB $f0
	DB $13
	DB $00
	DB $07
	DB $00
	DB $03
	DB $b6
	DB $00
	DB $25
	DB $b2
	DB $40
	DB $04
	DB $3f
	DB $39
	DB $00
	DB $03
	DB $6a
	DB $07
	DB $1b
	DB $9a
	DB $f8
	DB $65
	DB $9f
	DB $47
	DB $3c
	DB $9f
	DB $63
	DB $57
	DB $16
	DB $07
	DB $82
	DB $69
	DB $0f
	DB $03
	DB $01
	DB $c0
	DB $b5
	DB $1f
	DB $5f
	DB $80
	DB $fc
	DB $1f
	DB $5f
	DB $20
	DB $4f
	DB $80
	DB $85
	DB $20
	DB $fe
	DB $fe
	DB $e0
	DB $c4
	DB $9f
	DB $58
	DB $1f
	DB $7b
	DB $f3
	DB $1a
	DB $23
	DB $d1
	DB $3f
	DB $c1
	DB $9b
	DB $e4
	DB $cd
	DB $e2
	DB $e2
	DB $93
	DB $da
	DB $f6
	DB $47
	DB $60
	DB $81
	DB $fb
	DB $06
	DB $04
	DB $03
	DB $04
	DB $05
	DB $22
	DB $e6
	DB $71
	DB $e6
	DB $42
	DB $c0
	DB $d8
	DB $f9
	DB $00
	DB $d0
	DB $50
	DB $10
	DB $f2
	DB $41
	DB $00
	DB $e9
	DB $ca
	DB $80
	DB $01
	DB $a3
	DB $00
	DB $ab
	DB $38
	DB $e1
	DB $43
	DB $f4
	DB $1f
	DB $3f
	DB $8d
	DB $37
	DB $07
	DB $e0
	DB $8b
	DB $4d
	DB $70
	DB $69
	DB $fe
	DB $8d
	DB $bb
	DB $60
	DB $ab
	DB $cb
	DB $fd
	DB $58
	DB $56
	DB $00
	DB $07
	DB $c0
	DB $ef
	DB $00
	DB $45
	DB $19
	DB $38
	DB $00
	DB $aa
	DB $c8
	DB $3e
	DB $fe
	DB $8c
	DB $84
	DB $f6
	DB $f3
	DB $f1
	DB $a8
	DB $40
	DB $0c
	DB $e4
	DB $f1
	DB $61
	DB $80
	DB $08
	DB $80
	DB $08
	DB $88
	DB $04
	DB $c0
	DB $31
	DB $9c
	DB $21
	DB $83
	DB $30
	DB $4f
	DB $8f
	DB $8f
	DB $dd
	DB $0f
	DB $bd
	DB $1e
	DB $e7
	DB $00
	DB $07
	DB $77
	DB $f0
	DB $0f
	DB $7f
	DB $fe
	DB $40
	DB $0b
	DB $34
	DB $30
	DB $70
	DB $f0
	DB $05
	DB $05
	DB $12
	DB $04
	DB $04
	DB $14
	DB $02
	DB $06
	DB $fe
	DB $00
	DB $27
	DB $24
	DB $24
	DB $a4
	DB $84
	DB $00
	DB $00
	DB $e0
	DB $d0
	DB $81
	DB $2b
	DB $90
	DB $00
	DB $8b
	DB $fb
	DB $0f
	DB $83
	DB $c9
	DB $80
	DB $75
	DB $3e
	DB $37
	DB $00
	DB $3e
	DB $9a
	DB $d8
	DB $0f
	DB $f2
	DB $2d
	DB $01
	DB $e0
	DB $c4
	DB $80
	DB $f8
	DB $70
	DB $23
	DB $a0
	DB $2b
	DB $d8
	DB $08
	DB $17
	DB $27
	DB $47
	DB $f0
	DB $c2
	DB $0c
	DB $78
	DB $b8
	DB $c7
	DB $01
	DB $f7
	DB $79
	DB $71
	DB $a0
	DB $00
	DB $9e
	DB $e7
	DB $c7
	DB $d0
	DB $00
	DB $07
	DB $0c
	DB $10
	DB $1c
	DB $1f
	DB $1c
	DB $00
	DB $0e
	DB $c1
	DB $61
	DB $20
	DB $71
	DB $f1
	DB $38
	DB $11
	DB $21
	DB $c1
	DB $c3
	DB $d0
	DB $16
	DB $c3
	DB $f8
	DB $39
	DB $9c
	DB $0e
	DB $00
	DB $9c
	DB $c1
	DB $fb
	DB $df
	DB $00
	DB $f0
	DB $fc
	DB $05
	DB $ec
	DB $ee
	DB $d0
	DB $d8
	DB $70
	DB $c1
	DB $f1
	DB $e2
	DB $00
	DB $06
	DB $78
	DB $86
	DB $d0
	DB $ae
	DB $2c
	DB $94
	DB $48
	DB $8c
	DB $40
	DB $fc
	DB $7e
	DB $3e
	DB $ff
	DB $f3
	DB $f3
	DB $e0
	DB $b8
	DB $7b
	DB $1f
	DB $45
	DB $35
	DB $c5
	DB $05
	DB $14
	DB $11
	DB $31
	DB $31
	DB $11
	DB $2e
	DB $80
	DB $0d
	DB $e7
	DB $a2
	DB $20
	DB $20
	DB $00
	DB $00
	DB $a0
	DB $80
	DB $42
	DB $02
	DB $06
	DB $82
	DB $82
	DB $80
	DB $a2
	DB $3b
	DB $37
	DB $84
	DB $82
	DB $51
	DB $80
	DB $f9
	DB $64
	DB $34
	DB $47
	DB $1c
	DB $88
	DB $6c
	DB $44
	DB $00
	DB $a0
	DB $c0
	DB $59
	DB $02
	DB $04
	DB $08
	DB $00
	DB $50
	DB $10
	DB $04
	DB $08
	DB $21
	DB $47
	DB $8f
	DB $61
	DB $3f
	DB $0f
	DB $60
	DB $f0
	DB $88
	DB $f6
	DB $0f
	DB $b4
	DB $00
	DB $70
	DB $fe
	DB $98
	DB $b7
	DB $83
	DB $8f
	DB $07
	DB $dc
	DB $1e
	DB $07
	DB $fb
	DB $7d
	DB $07
	DB $a1
	DB $6f
	DB $87
	DB $1e
	DB $07
	DB $c3
	DB $3c
	DB $07
	DB $e1
	DB $07
	DB $7e
	DB $f0
	DB $6b
	DB $47
	DB $80
	DB $00
	DB $e1
	DB $a0
	DB $0c
	DB $30
	DB $04
	DB $e6
	DB $be
	DB $61
	DB $01
	DB $e0
	DB $0d
	DB $00
	DB $0c
	DB $3e
	DB $1b
	DB $d2
	DB $a2
	DB $96
	DB $8f
	DB $09
	DB $ee
	DB $78
	DB $9f
	DB $3b
	DB $00
	DB $0a
	DB $83
	DB $99
	DB $07
	DB $06
	DB $03
	DB $df
	DB $80
	DB $08
	DB $dc
	DB $ed
	DB $09
	DB $10
	DB $f9
	DB $04
	DB $0c
	DB $ed
	DB $8a
	DB $28
	DB $38
	DB $10
	DB $35
	DB $b7
	DB $0a
	DB $cf
	DB $a0
	DB $00
	DB $04
	DB $02
	DB $08
	DB $02
	DB $e6
	DB $27
	DB $90
	DB $8e
	DB $2f
	DB $20
	DB $03
	DB $21
	DB $08
	DB $14
	DB $f7
	DB $48
	DB $03
	DB $b1
	DB $2c
	DB $07
	DB $c3
	DB $60
	DB $30
	DB $03
	DB $c0
	DB $03
	DB $4f
	DB $04
	DB $11
	DB $0e
	DB $38
	DB $60
	DB $48
	DB $f0
	DB $c0
	DB $f3
	DB $01
	DB $00
	DB $42
	DB $00
	DB $84
	DB $84
	DB $04
	DB $6c
	DB $14
	DB $ea
	DB $e0
	DB $b1
	DB $db
	DB $b1
	DB $03
	DB $e7
	DB $82
	DB $fb
	DB $e7
	DB $df
	DB $bf
	DB $0c
	DB $92
	DB $4d
	DB $e0
	DB $75
	DB $fc
	DB $f8
	DB $5d
	DB $17
	DB $f5
	DB $0f
	DB $a0
	DB $81
	DB $ba
	DB $07
	DB $b0
	DB $07
	DB $cf
	DB $06
	DB $0c
	DB $33
	DB $18
	DB $30
	DB $07
	DB $91
	DB $d3
	DB $1e
	DB $ac
	DB $de
	DB $0b
	DB $70
	DB $00
	DB $58
	DB $e6
	DB $18
	DB $7f
	DB $b4
	DB $ec
	DB $1c
	DB $00
	DB $78
	DB $9d
	DB $0f
	DB $e3
	DB $da
	DB $f3
	DB $4f
	DB $e0
	DB $fc
	DB $1b
	DB $0f
	DB $7e
	DB $c5
	DB $b4
	DB $de
	DB $14
	DB $62
	DB $84
	DB $ff
	DB $a6
	DB $8d
	DB $da
	DB $f9
	DB $58
	DB $80
	DB $f3
	DB $ef
	DB $fe
	DB $95
	DB $27
	DB $00
	DB $0d
	DB $b6
	DB $9e
	DB $d8
	DB $00
	DB $fa
	DB $0f
	DB $40
	DB $ce
	DB $12
	DB $b9
	DB $40
	DB $03
	DB $41
	DB $30
	DB $18
	DB $20
	DB $0c
	DB $07
	DB $d6
	DB $08
	DB $70
	DB $bc
	DB $8f
	DB $44
	DB $8c
	DB $50
	DB $81
	DB $3e
	DB $30
	DB $80
	DB $c3
	DB $81
	DB $fc
	DB $c0
	DB $83
	DB $95
	DB $b1
	DB $db
	DB $80
	DB $18
	DB $76
	DB $4d
	DB $75
	DB $06
	DB $17
	DB $08
	DB $a1
	DB $0e
	DB $40
	DB $41
	DB $c1
	DB $10
	DB $8c
	DB $10
	DB $0f
	DB $8e
	DB $9b
	DB $96
	DB $6c
	DB $10
	DB $ee
	DB $80
	DB $04
	DB $1e
	DB $30
	DB $40
	DB $69
	DB $9f
	DB $9c
	DB $38
	DB $48
	DB $07
	DB $d9
	DB $00
	DB $1f
	DB $19
	DB $9c
	DB $78
	DB $38
	DB $20
	DB $dd
	DB $0f
	DB $c7
	DB $0f
	DB $d1
	DB $ce
	DB $1f
	DB $8e
	DB $21
	DB $ce
	DB $7c
	DB $70
	DB $2b
	DB $82
	DB $70
	DB $1c
	DB $00
	DB $f8
	DB $ec
	DB $84
	DB $7c
	DB $e0
	DB $ff
	DB $06
	DB $1e
	DB $1c
	DB $8e
	DB $00
	DB $be
	DB $14
	DB $e0
	DB $17
	DB $e0
	DB $e1
	DB $e1
	DB $e0
	DB $c0
	DB $03
	DB $7d
	DB $c6
	DB $c2
	DB $f0
	DB $0f
	DB $fc
	DB $3e
	DB $0e
	DB $8c
	DB $d4
	DB $bf
	DB $98
	DB $95
	DB $ae
	DB $00
	DB $3c
	DB $f8
	DB $8d
	DB $f8
	DB $05
	DB $04
	DB $0f
	DB $83
	DB $a2
	DB $05
	DB $06
	DB $0c
	DB $0c
	DB $08
	DB $d6
	DB $df
	DB $03
	DB $fc
	DB $03
	DB $c0
	DB $00
	DB $38
	DB $6c
	DB $b4
	DB $da
	DB $36
	DB $c0
	DB $d1
	DB $c7
	DB $50
	DB $04
	DB $09
	DB $23
	DB $7c
	DB $80
	DB $05
	DB $09
	DB $53
	DB $f7
	DB $ef
	DB $1b
	DB $7f
	DB $52
	DB $10
	DB $80
	DB $f5
	DB $4e
	DB $fd
	DB $e2
	DB $f6
	DB $1e
	DB $08
	DB $04
	DB $01
	DB $1e
	DB $89
	DB $cf
	DB $23
	DB $01
	DB $11
	DB $05
	DB $3f
	DB $f7
	DB $02
	DB $0e
	DB $09
	DB $13
	DB $23
	DB $83
	DB $e9
	DB $1c
	DB $65
	DB $94
	DB $2b
	DB $c0
	DB $ff
	DB $d9
	DB $00
	DB $a7
	DB $af
	DB $3f
	DB $51
	DB $f0
	DB $ed
	DB $00
	DB $92
	DB $f7
	DB $00
	DB $d1
	DB $f4
	DB $e5
	DB $da
	DB $df
	DB $da
	DB $97
	DB $cf
	DB $f0
	DB $fe
	DB $29
	DB $9f
	DB $3f
	DB $b1
	DB $c3
	DB $c3
	DB $dc
	DB $bc
	DB $ac
	DB $f7
	DB $00
	DB $28
	DB $84
	DB $08
	DB $18
	DB $18
	DB $e9
	DB $0a
	DB $a6
	DB $d2
	DB $0d
	DB $cf
	DB $81
	DB $30
	DB $31
	DB $33
	DB $7f
	DB $67
	DB $b3
	DB $88
	DB $b0
	DB $ed
	DB $7a
	DB $fd
	DB $18
	DB $47
	DB $00
	DB $40
	DB $f0
	DB $dc
	DB $a6
	DB $bf
	DB $83
	DB $00
	DB $1f
	DB $24
	DB $08
	DB $79
	DB $0e
	DB $10
	DB $0f
	DB $8e
	DB $1e
	DB $99
	DB $a3
	DB $8f
	DB $b5
	DB $3f
	DB $75
	DB $3c
	DB $9c
	DB $f8
	DB $f0
	DB $c0
	DB $f9
	DB $37
	DB $c0
	DB $10
	DB $13
	DB $f6
	DB $47
	DB $aa
	DB $78
	DB $40
	DB $8d
	DB $38
	DB $d6
	DB $d5
	DB $00
	DB $26
	DB $f8
	DB $d3
	DB $a7
	DB $fd
	DB $f9
	DB $89
	DB $3d
	DB $fc
	DB $3a
	DB $c0
	DB $59
	DB $89
	DB $d0
	DB $28
	DB $06
	DB $ec
	DB $bc
	DB $00
	DB $e0
	DB $8e
	DB $cf
	DB $c2
	DB $11
	DB $19
	DB $18
	DB $09
	DB $34
	DB $ee
	DB $8f
	DB $21
	DB $7e
	DB $fe
	DB $ae
	DB $fc
	DB $94
	DB $12
	DB $ff
	DB $f7
	DB $00
	DB $7f
	DB $af
	DB $fb
	DB $c4
	DB $00
	DB $fe
	DB $fd
	DB $f1
	DB $40
	DB $f9
	DB $f3
	DB $e7
	DB $8f
	DB $1e
	DB $1d
	DB $ba
	DB $30
	DB $e0
	DB $a5
	DB $7e
	DB $b6
	DB $00
	DB $78
	DB $b6
	DB $3b
	DB $13
	DB $11
	DB $34
	DB $08
	DB $0c
	DB $a3
	DB $a1
	DB $f7
	DB $f7
	DB $fb
	DB $90
	DB $d3
	DB $be
	DB $92
	DB $f5
	DB $14
	DB $0d
	DB $fe
	DB $ee
	DB $2e
	DB $11
	DB $17
	DB $93
	DB $5e
	DB $b4
	DB $7c
	DB $d9
	DB $ba
	DB $26
	DB $f4
	DB $fe
	DB $00
	DB $b0
	DB $11
	DB $f6
	DB $92
	DB $09
	DB $05
	DB $3c
	DB $0a
	DB $8c
	DB $f3
	DB $1e
	DB $3f
	DB $d3
	DB $d4
	DB $ad
	DB $1f
	DB $7d
	DB $03
	DB $ff
	DB $0e
	DB $d3
	DB $5b
	DB $8e
	DB $d1
	DB $d6
	DB $e0
	DB $e9
	DB $fe
	DB $71
	DB $00
	DB $d8
	DB $dd
	DB $cf
	DB $c7
	DB $78
	DB $e0
	DB $f0
	DB $d2
	DB $04
	DB $c5
	DB $70
	DB $01
	DB $f3
	DB $fe
	DB $d9
	DB $17
	DB $b3
	DB $e6
	DB $7c
	DB $d0
	DB $54
	DB $f6
	DB $38
	DB $ba
	DB $d4
	DB $a3
	DB $aa
	DB $cf
	DB $bf
	DB $c0
	DB $00
	DB $0c
	DB $02
	DB $02
	DB $01
	DB $e6
	DB $d3
	DB $02
	DB $79
	DB $7c
	DB $3c
	DB $1e
	DB $0b
	DB $81
	DB $07
	DB $69
	DB $87
	DB $a6
	DB $28
	DB $80
	DB $9f
	DB $f1
	DB $f3
	DB $35
	DB $e2
	DB $f4
	DB $a3
	DB $e2
	DB $30
	DB $f9
	DB $1f
	DB $5f
	DB $60
	DB $df
	DB $fa
	DB $69
	DB $78
	DB $a3
	DB $e5
	DB $b2
	DB $f8
	DB $a2
	DB $89
	DB $5f
	DB $60
	DB $fc
	DB $87
	DB $37
	DB $9f
	DB $0f
	DB $93
	DB $8e
	DB $aa
	DB $e0
	DB $ff
	DB $73
	DB $b2
	DB $20
	DB $3f
	DB $d2
	DB $fc
	DB $bc
	DB $23
	DB $3e
	DB $39
	DB $17
	DB $e8
	DB $94
	DB $ff
	DB $80
	DB $f1
	DB $98
	DB $a8
	DB $13
	DB $03
	DB $9d
	DB $7b
	DB $33
	DB $2a
	DB $10
	DB $86
	DB $e7
	DB $be
	DB $f2
	DB $68
	DB $c0
	DB $92
	DB $92
	DB $7a
	DB $06
	DB $af
	DB $e9
	DB $ee
	DB $3f
	DB $42
	DB $f4
	DB $d9
	DB $f5
	DB $b3
	DB $a5
	DB $48
	DB $0d
	DB $0d
	DB $d0
	DB $8a
	DB $e2
	DB $34
	DB $2f
	DB $8d
	DB $8e
	DB $e9
	DB $2e
	DB $ea
	DB $8f
	DB $47
	DB $a3
	DB $00
	DB $09
	DB $e5
	DB $74
	DB $10
	DB $18
	DB $2c
	DB $94
	DB $56
	DB $dc
	DB $b9
	DB $b3
	DB $ff
	DB $bf
	DB $17
	DB $ac
	DB $33
	DB $84
	DB $50
	DB $f8
	DB $74
	DB $00
	DB $94
	DB $e5
	DB $1c
	DB $00
	DB $ac
	DB $b6
	DB $1f
	DB $c7
	DB $3c
	DB $93
	DB $b8
	DB $ff
	DB $06
	DB $01
	DB $aa
	DB $91
	DB $bf
	DB $2e
	DB $6a
	DB $f8
	DB $c9
	DB $d8
	DB $df
	DB $5f
	DB $07
	DB $55
	DB $cf
	DB $11
	DB $16
	DB $cf
	DB $ab
	DB $d8
	DB $00
	DB $e7
	DB $0a
	DB $19
	DB $f9
	DB $80
	DB $3e
	DB $7e
	DB $f8
	DB $30
	DB $48
	DB $80
	DB $89
	DB $eb
	DB $60
	DB $c3
	DB $8d
	DB $c5
	DB $03
	DB $0f
	DB $3c
	DB $d4
	DB $85
	DB $03
	DB $1f
	DB $64
	DB $c3
	DB $22
	DB $74
	DB $30
	DB $10
	DB $74
	DB $3a
	DB $80
	DB $f9
	DB $13
	DB $01
	DB $de
	DB $df
	DB $20
	DB $ec
	DB $ec
	DB $e6
	DB $e6
	DB $63
	DB $e2
	DB $87
	DB $98
	DB $38
	DB $19
	DB $54
	DB $30
	DB $66
	DB $30
	DB $f9
	DB $9d
	DB $98
	DB $98
	DB $27
	DB $af
	DB $a3
	DB $ce
	DB $22
	DB $f1
	DB $e0
	DB $f2
	DB $d6
	DB $59
	DB $0f
	DB $d2
	DB $97
	DB $c3
	DB $a2
	DB $3e
	DB $af
	DB $fe
	DB $c6
	DB $4d
	DB $d4
	DB $fa
	DB $04
	DB $01
	DB $f1
	DB $9c
	DB $06
	DB $e4
	DB $c0
	DB $ea
	DB $80
	DB $ef
	DB $60
	DB $c0
	DB $89
	DB $b5
	DB $e0
	DB $ac
	DB $4b
	DB $80
	DB $36
	DB $86
	DB $8e
	DB $cd
	DB $a3
	DB $30
	DB $60
	DB $4c
	DB $2b
	DB $09
	DB $c0
	DB $5a
	DB $90
	DB $ef
	DB $7f
	DB $bf
	DB $72
	DB $6f
	DB $1d
	DB $e6
	DB $9a
	DB $15
	DB $c3
	DB $3f
	DB $1f
	DB $e2
	DB $26
	DB $f2
	DB $1b
	DB $85
	DB $1f
	DB $31
	DB $ef
	DB $07
	DB $6e
	DB $ec
	DB $c1
	DB $9b
	DB $d3
	DB $d2
	DB $d0
	DB $07
	DB $99
	DB $cb
	DB $a0
	DB $ae
	DB $e0
	DB $f9
	DB $76
	DB $8c
	DB $31
	DB $fb
	DB $60
	DB $fe
	DB $0c
	DB $d7
	DB $e4
	DB $28
	DB $60
	DB $76
	DB $1c
	DB $80
	DB $cb
	DB $7b
	DB $84
	DB $be
	DB $af
	DB $0d
	DB $de
	DB $f1
	DB $2c
	DB $df
	DB $25
	DB $3f
	DB $47
	DB $2c
	DB $9d
	DB $f3
	DB $05
	DB $03
	DB $87
	DB $ad
	DB $51
	DB $0e
	DB $22
	DB $c0
	DB $70
	DB $b5
	DB $8d
	DB $1f
	DB $01
	DB $00
	DB $87
	DB $0e
	DB $1c
	DB $3c
	DB $f8
	DB $f9
	DB $f1
	DB $1c
	DB $0c
	DB $1c
	DB $3d
	DB $7b
	DB $7f
	DB $cd
	DB $4d
	DB $25
	DB $ae
	DB $08
	DB $05
	DB $ff
	DB $03
	DB $cf
	DB $96
	DB $3c
	DB $9b
	DB $20
	DB $82
	DB $30
	DB $40
	DB $38
	DB $3c
	DB $8f
	DB $1f
	DB $cb
	DB $a9
	DB $b2
	DB $e4
	DB $9d
	DB $38
	DB $2b
	DB $fc
	DB $f0
	DB $ae
	DB $22
	DB $4c
	DB $51
	DB $d8
	DB $e7
	DB $b9
	DB $16
	DB $1f
	DB $bf
	DB $f5
	DB $d1
	DB $70
	DB $f1
	DB $c0
	DB $9e
	DB $f0
	DB $4b
	DB $be
	DB $8c
	DB $29
	DB $ec
	DB $f1
	DB $07
	DB $81
	DB $bf
	DB $c3
	DB $88
	DB $02
	DB $c7
	DB $7f
	DB $05
	DB $81
	DB $cf
	DB $3c
	DB $94
	DB $ea
	DB $00
	DB $99
	DB $13
	DB $3c
	DB $e9
	DB $99
	DB $27
	DB $b8
	DB $99
	DB $32
	DB $13
	DB $ff
	DB $02
	DB $34
	DB $3f
	DB $3c
	DB $cf
	DB $52
	DB $c3
	DB $2f
	DB $cb
	DB $78
	DB $b8
	DB $31
	DB $c2
	DB $46
	DB $80
	DB $01
	DB $07
	DB $3c
	DB $14
	DB $3f
	DB $f1
	DB $c2
	DB $f3
	DB $f3
	DB $3b
	DB $2e
	DB $cf
	DB $9f
	DB $0d
	DB $ae
	DB $b0
	DB $ce
	DB $dc
	DB $f8
	DB $f7
	DB $30
	DB $c0
	DB $c1
	DB $3a
	DB $50
	DB $80
	DB $7f
	DB $b0
	DB $0b
	DB $c0
	DB $06
	DB $d8
	DB $c4
	DB $d0
	DB $02
	DB $5b
	DB $18
	DB $67
	DB $df
	DB $51
	DB $bf
	DB $44
	DB $82
	DB $c2
	DB $89
	DB $80
	DB $cd
	DB $a4
	DB $d9
	DB $9e
	DB $34
	DB $87
	DB $1f
	DB $98
	DB $ff
	DB $61
	DB $90
	DB $18
	DB $11
	DB $12
	DB $12
	DB $07
	DB $c6
	DB $0c
	DB $23
	DB $e2
	DB $22
	DB $62
	DB $07
	DB $33
	DB $c3
	DB $24
	DB $00
	DB $01
	DB $07
	DB $8f
	DB $51
	DB $50
	DB $50
	DB $51
	DB $78
	DB $d3
	DB $20
	DB $2c
	DB $32
	DB $58
	DB $22
	DB $00
	DB $0f
	DB $38
	DB $0c
	DB $45
	DB $7d
	DB $40
	DB $45
	DB $07
	DB $07
	DB $e7
	DB $29
	DB $8c
	DB $63
	DB $29
	DB $ec
	DB $85
	DB $2d
	DB $e0
	DB $8d
	DB $67
	DB $c0
	DB $07
	DB $87
	DB $ef
	DB $c7
	DB $e5
	DB $1d
	DB $0f
	DB $f8
	DB $9e
	DB $a3
	DB $75
	DB $84
	DB $6c
	DB $e4
	DB $44
	DB $38
	DB $01
	DB $ac
	DB $10
	DB $0f
	DB $f8
	DB $c0
	DB $04
	DB $64
	DB $e0
	DB $e4
	DB $18
	DB $cc
	DB $30
	DB $c9
	DB $fc
	DB $df
	DB $d0
	DB $f5
	DB $61
	DB $c1
	DB $5c
	DB $24
	DB $f6
	DB $10
	DB $ea
	DB $1e
	DB $c7
	DB $1f
	DB $86
	DB $e4
	DB $f7
	DB $b3
	DB $17
	DB $a8
	DB $c8
	DB $f1
	DB $e3
	DB $8b
	DB $cd
	DB $0e
	DB $60
	DB $53
	DB $af
	DB $56
	DB $10
	DB $00
	DB $e0
	DB $f8
	DB $3b
	DB $05
	DB $dd
	DB $07
	DB $00
	DB $c1
	DB $e0
	DB $8c
	DB $3a
	DB $d6
	DB $fa
	DB $6c
	DB $00
	DB $31
	DB $88
	DB $08
	DB $8a
	DB $6d
	DB $00
	DB $cc
	DB $f8
	DB $78
	DB $b9
	DB $07
	DB $b7
	DB $f1
	DB $07
	DB $73
	DB $e3
	DB $07
	DB $8e
	DB $c7
	DB $07
	DB $77
	DB $8f
	DB $07
	DB $39
	DB $1e
	DB $07
	DB $ce
	DB $a7
	DB $ca
	DB $41
	DB $d7
	DB $46
	DB $00
	DB $f5
	DB $81
	DB $08
	DB $0f
	DB $fc
	DB $f3
	DB $4f
	DB $ee
	DB $a0
	DB $be
	DB $00
	DB $df
	DB $5f
	DB $ef
	DB $ff
	DB $cc
	DB $c4
	DB $f0
	DB $fc
	DB $e3
	DB $f8
	DB $28
	DB $0f
	DB $38
	DB $8f
	DB $92
	DB $cc
	DB $db
	DB $22
	DB $0e
	DB $3c
	DB $b8
	DB $2b
	DB $05
	DB $62
	DB $f8
	DB $60
	DB $80
	DB $a0
	DB $60
	DB $ea
	DB $1a
	DB $1c
	DB $7b
	DB $11
	DB $3d
	DB $87
	DB $4f
	DB $03
	DB $f8
	DB $e1
	DB $97
	DB $a1
	DB $2a
	DB $04
	DB $0f
	DB $3b
	DB $31
	DB $40
	DB $a3
	DB $0a
	DB $8a
	DB $ea
	DB $bd
	DB $cc
	DB $09
	DB $16
	DB $40
	DB $f9
	DB $5d
	DB $fb
	DB $ff
	DB $f6
	DB $f0
	DB $e1
	DB $15
	DB $81
	DB $1c
	DB $38
	DB $63
	DB $b0
	DB $be
	DB $b4
	DB $df
	DB $d9
	DB $54
	DB $a8
	DB $a9
	DB $21
	DB $fc
	DB $be
	DB $21
	DB $36
	DB $40
	DB $14
	DB $07
	DB $fb
	DB $a3
	DB $73
	DB $74
	DB $87
	DB $80
	DB $56
	DB $f7
	DB $a1
	DB $03
	DB $04
	DB $ff
	DB $1b
	DB $ad
	DB $07
	DB $42
	DB $fd
	DB $1c
	DB $c4
	DB $04
	DB $e3
	DB $07
	DB $20
	DB $18
	DB $21
	DB $22
	DB $c7
	DB $c3
	DB $50
	DB $06
	DB $c2
	DB $04
	DB $e7
	DB $96
	DB $07
	DB $40
	DB $f0
	DB $c7
	DB $00
	DB $e0
	DB $40
	DB $a9
	DB $87
	DB $71
	DB $95
	DB $06
	DB $e7
	DB $ef
	DB $ef
	DB $df
	DB $a3
	DB $0f
	DB $f8
	DB $9f
	DB $8c
	DB $47
	DB $e7
	DB $b8
	DB $85
	DB $7c
	DB $f0
	DB $5b
	DB $f8
	DB $a4
	DB $c4
	DB $ad
	DB $01
	DB $95
	DB $88
	DB $00
	DB $81
	DB $f4
	DB $a0
	DB $d1
	DB $36
	DB $f8
	DB $27
	DB $20
	DB $1f
	DB $fe
	DB $f1
	DB $00
	DB $e0
	DB $f1
	DB $c5
	DB $80
	DB $e0
	DB $19
	DB $71
	DB $f3
	DB $90
	DB $a8
	DB $3b
	DB $27
	DB $d8
	DB $15
	DB $c3
	DB $06
	DB $e9
	DB $05
	DB $e4
	DB $a8
	DB $16
	DB $ea
	DB $3e
	DB $86
	DB $d2
	DB $0f
	DB $0e
	DB $fb
	DB $09
	DB $c3
	DB $6d
	DB $46
	DB $76
	DB $bd
	DB $9a
	DB $03
	DB $89
	DB $8e
	DB $f2
	DB $2f
	DB $c1
	DB $9d
	DB $72
	DB $3f
	DB $f3
	DB $7a
	DB $f5
	DB $f7
	DB $3d
	DB $40
	DB $f1
	DB $8f
	DB $e0
	DB $f9
	DB $d8
	DB $07
	DB $7f
	DB $7c
	DB $24
	DB $3c
	DB $0f
	DB $e8
	DB $71
	DB $ef
	DB $ca
	DB $09
	DB $e1
	DB $9c
	DB $18
	DB $bd
	DB $21
	DB $b0
	DB $c2
	DB $a0
	DB $85
	DB $9c
	DB $bf
	DB $00
	DB $03
	DB $12
	DB $20
	DB $43
	DB $86
	DB $0c
	DB $3f
	DB $12
	DB $62
	DB $60
	DB $92
	DB $c0
	DB $e0
	DB $f0
	DB $38
	DB $09
	DB $16
	DB $18
	DB $00
	DB $df
	DB $f0
	DB $be
	DB $9d
	DB $af
	DB $a6
	DB $fd
	DB $ae
	DB $ed
	DB $80
	DB $d2
	DB $aa
	DB $75
	DB $60
	DB $14
	DB $05
	DB $25
	DB $23
	DB $63
	DB $88
	DB $89
	DB $f7
	DB $f7
	DB $e4
	DB $ed
	DB $49
	DB $f8
	DB $00
	DB $ff
	DB $e3
	DB $74
	DB $27
	DB $70
	DB $fc
	DB $ea
	DB $ef
	DB $6a
	DB $27
	DB $fd
	DB $ef
	DB $1f
	DB $ff
	DB $ff
	DB $ff
	DB $f8
cvb_CAMELOT_TITLE_COLOR:
	DB $5a
	DB $41
	DB $ab
	DB $89
	DB $00
	DB $f4
	DB $00
	DB $f1
	DB $e7
	DB $03
	DB $3d
	DB $00
	DB $41
	DB $ff
	DB $bc
	DB $00
	DB $e7
	DB $0b
	DB $f1
	DB $00
	DB $3d
	DB $04
	DB $03
	DB $f1
	DB $f1
	DB $f5
	DB $50
	DB $f0
	DB $5b
	DB $02
	DB $2d
	DB $e3
	DB $e1
	DB $f4
	DB $de
	DB $00
	DB $78
	DB $06
	DB $80
	DB $7f
	DB $b7
	DB $07
	DB $d5
	DB $86
	DB $ef
	DB $83
	DB $f3
	DB $61
	DB $d2
	DB $f9
	DB $d7
	DB $3c
	DB $0c
	DB $7b
	DB $f1
	DB $6f
	DB $00
	DB $1f
	DB $8c
	DB $35
	DB $07
	DB $dd
	DB $16
	DB $c6
	DB $fd
	DB $19
	DB $f0
	DB $ef
	DB $ed
	DB $03
	DB $4d
	DB $cc
	DB $ee
	DB $7e
	DB $43
	DB $0d
	DB $fe
	DB $d8
	DB $ec
	DB $7d
	DB $15
	DB $b8
	DB $9d
	DB $7f
	DB $7e
	DB $a5
	DB $bf
	DB $81
	DB $cd
	DB $f1
	DB $b0
	DB $c9
	DB $f0
	DB $ef
	DB $6a
	DB $4e
	DB $d7
	DB $15
	DB $d5
	DB $66
	DB $4b
	DB $f1
	DB $b9
	DB $00
	DB $bb
	DB $d1
	DB $ec
	DB $b4
	DB $9f
	DB $00
	DB $6b
	DB $07
	DB $e7
	DB $2e
	DB $5f
	DB $27
	DB $07
	DB $da
	DB $2f
	DB $ed
	DB $3f
	DB $e9
	DB $99
	DB $3f
	DB $93
	DB $b3
	DB $f4
	DB $f6
	DB $f0
	DB $1a
	DB $7c
	DB $1c
	DB $df
	DB $3d
	DB $ed
	DB $00
	DB $d9
	DB $f1
	DB $5b
	DB $17
	DB $a0
	DB $c4
	DB $da
	DB $00
	DB $0b
	DB $fd
	DB $c7
	DB $00
	DB $b1
	DB $da
	DB $44
	DB $ed
	DB $00
	DB $f8
	DB $a8
	DB $2f
	DB $06
	DB $fa
	DB $85
	DB $5b
	DB $fb
	DB $57
	DB $6f
	DB $00
	DB $ea
	DB $81
	DB $b4
	DB $d7
	DB $f3
	DB $07
	DB $7e
	DB $ed
	DB $1a
	DB $9f
	DB $0a
	DB $9f
	DB $12
	DB $0d
	DB $97
	DB $95
	DB $f7
	DB $27
	DB $fc
	DB $f0
	DB $3d
	DB $64
	DB $e6
	DB $51
	DB $f4
	DB $00
	DB $d4
	DB $10
	DB $d3
	DB $1a
	DB $75
	DB $0e
	DB $87
	DB $bd
	DB $cf
	DB $1e
	DB $b4
	DB $c3
	DB $d6
	DB $bf
	DB $14
	DB $2f
	DB $0f
	DB $27
	DB $41
	DB $f6
	DB $fd
	DB $0f
	DB $aa
	DB $2d
	DB $e8
	DB $d4
	DB $90
	DB $7f
	DB $7e
	DB $08
	DB $8e
	DB $00
	DB $a1
	DB $00
	DB $f0
	DB $ec
	DB $69
	DB $07
	DB $83
	DB $f9
	DB $50
	DB $fc
	DB $77
	DB $04
	DB $6b
	DB $23
	DB $f0
	DB $ff
	DB $ff
	DB $26
	DB $ce
	DB $bb
	DB $6f
	DB $16
	DB $5f
	DB $c4
	DB $fc
	DB $00
	DB $de
	DB $f5
	DB $5f
	DB $df
	DB $0f
	DB $0d
	DB $fc
	DB $cd
	DB $00
	DB $4f
	DB $13
	DB $ee
	DB $19
	DB $2e
	DB $dd
	DB $e3
	DB $87
	DB $bf
	DB $7c
	DB $00
	DB $d2
	DB $3e
	DB $db
	DB $1d
	DB $0e
	DB $ef
	DB $f7
	DB $00
	DB $a2
	DB $fc
	DB $d8
	DB $ef
	DB $69
	DB $0a
	DB $ef
	DB $75
	DB $00
	DB $28
	DB $26
	DB $ea
	DB $df
	DB $8f
	DB $57
	DB $fb
	DB $00
	DB $d2
	DB $f6
	DB $69
	DB $05
	DB $f6
	DB $0d
	DB $bb
	DB $6f
	DB $00
	DB $c3
	DB $f4
	DB $fb
	DB $12
	DB $5f
	DB $f0
	DB $fc
	DB $6a
	DB $9f
	DB $00
	DB $f0
	DB $f3
	DB $7f
	DB $a1
	DB $83
	DB $df
	DB $d5
	DB $c1
	DB $ff
	DB $bd
	DB $53
	DB $ba
	DB $8f
	DB $5f
	DB $21
	DB $3f
	DB $00
	DB $e9
	DB $b7
	DB $f0
	DB $e8
	DB $f8
	DB $f1
	DB $79
	DB $0d
	DB $76
	DB $07
	DB $0b
	DB $ae
	DB $6f
	DB $e7
	DB $b7
	DB $13
	DB $d6
	DB $ff
	DB $1a
	DB $e6
	DB $7f
	DB $b7
	DB $67
	DB $a6
	DB $07
	DB $9e
	DB $1f
	DB $0c
	DB $f6
	DB $02
	DB $d5
	DB $51
	DB $00
	DB $61
	DB $a9
	DB $00
	DB $ff
	DB $2d
	DB $df
	DB $d7
	DB $07
	DB $ff
	DB $7f
	DB $4a
	DB $1e
	DB $df
	DB $67
	DB $f5
	DB $f3
	DB $00
	DB $d0
	DB $f4
	DB $7f
	DB $d3
	DB $df
	DB $dd
	DB $ce
	DB $87
	DB $f1
	DB $dd
	DB $9a
	DB $6f
	DB $21
	DB $ba
	DB $0f
	DB $f4
	DB $af
	DB $af
	DB $b9
	DB $b7
	DB $6f
	DB $79
	DB $52
	DB $87
	DB $bd
	DB $41
	DB $54
	DB $00
	DB $c9
	DB $dd
	DB $99
	DB $68
	DB $dc
	DB $3d
	DB $50
	DB $f5
	DB $77
	DB $29
	DB $9d
	DB $8f
	DB $21
	DB $f7
	DB $07
	DB $a9
	DB $00
	DB $ef
	DB $0f
	DB $ff
	DB $f8
	DB $87
	DB $fa
	DB $a8
	DB $f7
	DB $b5
	DB $36
	DB $07
	DB $7b
	DB $e1
	DB $c7
	DB $fd
	DB $17
	DB $79
	DB $00
	DB $05
	DB $bb
	DB $0f
	DB $da
	DB $fb
	DB $00
	DB $f4
	DB $ff
	DB $5a
	DB $f4
	DB $e7
	DB $fc
	DB $87
	DB $2e
	DB $b4
	DB $00
	DB $ff
	DB $be
	DB $07
	DB $00
	DB $fe
	DB $1f
	DB $ff
	DB $42
	DB $9e
	DB $f1
	DB $fc
	DB $dd
	DB $5f
	DB $2d
	DB $f2
	DB $1e
	DB $b3
	DB $ee
	DB $7a
	DB $00
	DB $e5
	DB $ba
	DB $d4
	DB $fc
	DB $1f
	DB $f9
	DB $07
	DB $ef
	DB $8f
	DB $96
	DB $bc
	DB $0b
	DB $87
	DB $1f
	DB $f0
	DB $e8
	DB $dd
	DB $50
	DB $fa
	DB $7e
	DB $d7
	DB $87
	DB $17
	DB $d2
	DB $2e
	DB $d6
	DB $04
	DB $f7
	DB $2f
	DB $07
	DB $08
	DB $d6
	DB $00
	DB $da
	DB $af
	DB $7b
	DB $e0
	DB $e9
	DB $df
	DB $61
	DB $f9
	DB $df
	DB $6c
	DB $7f
	DB $74
	DB $d7
	DB $87
	DB $5d
	DB $9f
	DB $00
	DB $b4
	DB $f9
	DB $97
	DB $f4
	DB $ba
	DB $1f
	DB $66
	DB $07
	DB $08
	DB $a6
	DB $bf
	DB $d7
	DB $36
	DB $f2
	DB $83
	DB $ee
	DB $e1
	DB $f6
	DB $f7
	DB $0f
	DB $be
	DB $2f
	DB $de
	DB $bf
	DB $17
	DB $ef
	DB $27
	DB $7e
	DB $00
	DB $ff
	DB $ff
	DB $ff
	DB $ff
	DB $c0
cvb_GAME_SPRITES:
	DB $00
	DB $00
	DB $01
	DB $01
	DB $0f
	DB $1f
	DB $0e
	DB $07
	DB $03
	DB $07
	DB $07
	DB $02
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $5c
	DB $fe
	DB $fe
	DB $fc
	DB $e6
	DB $ec
	DB $fe
	DB $f4
	DB $20
	DB $60
	DB $00
	DB $00
	DB $00
	DB $07
	DB $04
	DB $3f
	DB $25
	DB $2f
	DB $3f
	DB $1e
	DB $1f
	DB $13
	DB $1f
	DB $0f
	DB $07
	DB $02
	DB $01
	DB $00
	DB $00
	DB $80
	DB $d0
	DB $3c
	DB $7c
	DB $fe
	DB $ff
	DB $fd
	DB $e7
	DB $ee
	DB $fe
	DB $f6
	DB $bc
	DB $ec
	DB $ec
	DB $00
	DB $00
	DB $00
	DB $0f
	DB $1f
	DB $1b
	DB $1e
	DB $1c
	DB $00
	DB $00
	DB $00
	DB $04
	DB $08
	DB $1f
	DB $34
	DB $1f
	DB $0f
	DB $03
	DB $00
	DB $00
	DB $07
	DB $8f
	DB $0f
	DB $07
	DB $43
	DB $60
	DB $00
	DB $00
	DB $00
	DB $0e
	DB $1e
	DB $1e
	DB $1c
	DB $00
	DB $00
	DB $00
	DB $00
	DB $05
	DB $0c
	DB $0c
	DB $00
	DB $10
	DB $10
	DB $10
	DB $00
	DB $00
	DB $18
	DB $0a
	DB $01
	DB $00
	DB $00
	DB $00
	DB $00
	DB $c0
	DB $20
	DB $04
	DB $0c
	DB $00
	DB $00
	DB $04
	DB $04
	DB $08
	DB $00
	DB $0c
	DB $c0
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $01
	DB $01
	DB $03
	DB $03
	DB $07
	DB $07
	DB $01
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $70
	DB $f8
	DB $f8
	DB $dc
	DB $9e
	DB $8e
	DB $0e
	DB $8e
	DB $fc
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $03
	DB $07
	DB $0f
	DB $0f
	DB $0f
	DB $06
	DB $03
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $c0
	DB $e0
	DB $f0
	DB $d0
	DB $b0
	DB $60
	DB $c0
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $01
	DB $01
	DB $01
	DB $01
	DB $01
	DB $01
	DB $01
	DB $07
	DB $01
	DB $01
	DB $01
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $80
	DB $80
	DB $80
	DB $80
	DB $80
	DB $80
	DB $e0
	DB $80
	DB $80
	DB $80
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $03
	DB $07
	DB $07
	DB $07
	DB $07
	DB $03
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $c0
	DB $e0
	DB $e0
	DB $e0
	DB $e0
	DB $c0
	DB $00
	DB $00
	DB $00
	DB $00
	DB $04
	DB $0c
	DB $0f
	DB $13
	DB $11
	DB $1f
	DB $08
	DB $04
	DB $07
	DB $1f
	DB $3f
	DB $74
	DB $6f
	DB $6e
	DB $00
	DB $00
	DB $20
	DB $30
	DB $f0
	DB $90
	DB $10
	DB $f0
	DB $20
	DB $40
	DB $c0
	DB $ec
	DB $fc
	DB $c0
	DB $60
	DB $70
	DB $70
	DB $78
	DB $04
	DB $0c
	DB $0f
	DB $09
	DB $08
	DB $0f
	DB $04
	DB $02
	DB $03
	DB $37
	DB $3f
	DB $03
	DB $06
	DB $0e
	DB $0e
	DB $1e
	DB $20
	DB $30
	DB $f0
	DB $c8
	DB $88
	DB $f8
	DB $10
	DB $20
	DB $e0
	DB $f8
	DB $fc
	DB $2e
	DB $f6
	DB $76
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $0f
	DB $13
	DB $11
	DB $1f
	DB $08
	DB $64
	DB $67
	DB $3f
	DB $07
	DB $04
	DB $0f
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $e0
	DB $90
	DB $10
	DB $f0
	DB $22
	DB $46
	DB $ce
	DB $fc
	DB $f0
	DB $c0
	DB $78
	DB $00
	DB $00
	DB $00
	DB $00
	DB $0f
	DB $13
	DB $11
	DB $1f
	DB $08
	DB $04
	DB $17
	DB $3f
	DB $27
	DB $24
	DB $5e
	DB $40
	DB $40
	DB $00
	DB $00
	DB $00
	DB $e0
	DB $90
	DB $10
	DB $f0
	DB $20
	DB $40
	DB $c8
	DB $f8
	DB $f4
	DB $c4
	DB $f4
	DB $06
	DB $02
	DB $00
	DB $00
	DB $00
	DB $0c
	DB $0e
	DB $00
	DB $07
	DB $03
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $60
	DB $e0
	DB $00
	DB $c0
	DB $80
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $06
	DB $07
	DB $00
	DB $03
	DB $01
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $30
	DB $70
	DB $00
	DB $e0
	DB $c0
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $01
	DB $03
	DB $00
	DB $4c
	DB $4e
	DB $40
	DB $67
	DB $13
	DB $10
	DB $00
	DB $00
	DB $00
	DB $00
	DB $0d
	DB $00
	DB $00
	DB $00
	DB $80
	DB $00
	DB $62
	DB $e2
	DB $06
	DB $c4
	DB $88
	DB $10
	DB $00
	DB $00
	DB $00
	DB $00
	DB $58
	DB $00
	DB $01
	DB $03
	DB $00
	DB $0c
	DB $0e
	DB $00
	DB $07
	DB $33
	DB $20
	DB $40
	DB $40
	DB $40
	DB $80
	DB $9a
	DB $80
	DB $00
	DB $00
	DB $80
	DB $00
	DB $60
	DB $e0
	DB $00
	DB $c0
	DB $8c
	DB $14
	DB $04
	DB $02
	DB $02
	DB $02
	DB $b1
	DB $01
	DB $06
	DB $0a
	DB $12
	DB $11
	DB $10
	DB $08
	DB $6c
	DB $93
	DB $80
	DB $80
	DB $f0
	DB $08
	DB $08
	DB $11
	DB $21
	DB $21
	DB $60
	DB $50
	DB $48
	DB $88
	DB $08
	DB $10
	DB $20
	DB $c0
	DB $18
	DB $04
	DB $02
	DB $51
	DB $91
	DB $9f
	DB $60
	DB $00
	DB $06
	DB $0a
	DB $12
	DB $11
	DB $10
	DB $08
	DB $04
	DB $03
	DB $18
	DB $20
	DB $40
	DB $8a
	DB $89
	DB $f9
	DB $06
	DB $00
	DB $60
	DB $50
	DB $48
	DB $88
	DB $08
	DB $10
	DB $36
	DB $c9
	DB $01
	DB $01
	DB $0f
	DB $10
	DB $10
	DB $88
	DB $84
	DB $84
	DB $06
	DB $08
	DB $10
	DB $10
	DB $72
	DB $98
	DB $9b
	DB $95
	DB $82
	DB $80
	DB $f0
	DB $08
	DB $08
	DB $11
	DB $21
	DB $21
	DB $60
	DB $10
	DB $08
	DB $08
	DB $48
	DB $10
	DB $c0
	DB $a0
	DB $58
	DB $04
	DB $02
	DB $51
	DB $91
	DB $9f
	DB $84
	DB $84
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $0c
	DB $08
	DB $15
	DB $35
	DB $01
	DB $00
	DB $00
	DB $04
	DB $00
	DB $00
	DB $00
	DB $08
	DB $10
	DB $00
	DB $00
	DB $00
	DB $04
	DB $54
	DB $50
	DB $54
	DB $14
	DB $00
	DB $00
	DB $02
	DB $01
	DB $01
	DB $01
	DB $00
	DB $01
	DB $01
	DB $00
	DB $6c
	DB $7c
	DB $0f
	DB $0f
	DB $00
	DB $07
	DB $00
	DB $1e
	DB $1e
	DB $80
	DB $a0
	DB $b0
	DB $70
	DB $f0
	DB $e0
	DB $00
	DB $30
	DB $00
	DB $e0
	DB $78
	DB $0a
	DB $0e
	DB $60
	DB $00
	DB $00
	DB $01
	DB $01
	DB $01
	DB $00
	DB $01
	DB $01
	DB $00
	DB $0c
	DB $00
	DB $07
	DB $1e
	DB $50
	DB $70
	DB $06
	DB $00
	DB $00
	DB $80
	DB $a0
	DB $b0
	DB $70
	DB $f0
	DB $e0
	DB $00
	DB $36
	DB $3e
	DB $f0
	DB $f0
	DB $00
	DB $e0
	DB $00
	DB $78
	DB $78
	DB $01
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $68
	DB $7c
	DB $0f
	DB $0f
	DB $00
	DB $07
	DB $00
	DB $1e
	DB $1e
	DB $80
	DB $20
	DB $10
	DB $10
	DB $10
	DB $00
	DB $00
	DB $10
	DB $00
	DB $e0
	DB $78
	DB $0a
	DB $0e
	DB $60
	DB $78
	DB $78
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $1c
	DB $3e
	DB $73
	DB $77
	DB $ea
	DB $4a
	DB $7e
	DB $38
	DB $07
	DB $0a
	DB $00
	DB $00
	DB $00
	DB $14
	DB $08
	DB $32
	DB $23
	DB $41
	DB $71
	DB $ab
	DB $af
	DB $ab
	DB $6a
	DB $44
	DB $c2
	DB $05
	DB $00
	DB $04
	DB $0c
	DB $0e
	DB $0e
	DB $06
	DB $03
	DB $00
	DB $03
	DB $70
	DB $00
	DB $07
	DB $00
	DB $06
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $c0
	DB $00
	DB $e0
	DB $18
	DB $84
	DB $a4
	DB $60
	DB $00
	DB $00
	DB $00
	DB $00
	DB $04
	DB $0c
	DB $0e
	DB $0e
	DB $06
	DB $03
	DB $00
	DB $07
	DB $18
	DB $21
	DB $25
	DB $06
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $c0
	DB $00
	DB $c0
	DB $0e
	DB $00
	DB $e0
	DB $00
	DB $60
	DB $00
	DB $00
	DB $00
	DB $07
	DB $0f
	DB $08
	DB $08
	DB $00
	DB $00
	DB $00
	DB $00
	DB $70
	DB $00
	DB $07
	DB $00
	DB $06
	DB $00
	DB $00
	DB $00
	DB $c0
	DB $e0
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $20
	DB $18
	DB $84
	DB $a4
	DB $60
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $07
	DB $05
	DB $67
	DB $64
	DB $02
	DB $01
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $e0
	DB $a0
	DB $e0
	DB $20
	DB $40
	DB $80
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $8f
	DB $d0
	DB $47
	DB $40
	DB $5c
	DB $1a
	DB $0e
	DB $06
	DB $10
	DB $1d
	DB $47
	DB $a3
	DB $a1
	DB $b0
	DB $90
	DB $88
	DB $f0
	DB $0b
	DB $e2
	DB $02
	DB $3a
	DB $58
	DB $70
	DB $60
	DB $10
	DB $58
	DB $f2
	DB $e7
	DB $47
	DB $0e
	DB $0a
	DB $10
	DB $0f
	DB $d0
	DB $47
	DB $40
	DB $5c
	DB $1a
	DB $0e
	DB $06
	DB $08
	DB $1a
	DB $4f
	DB $e7
	DB $e2
	DB $70
	DB $50
	DB $08
	DB $f1
	DB $0b
	DB $e2
	DB $02
	DB $3a
	DB $58
	DB $70
	DB $60
	DB $08
	DB $b8
	DB $e2
	DB $c5
	DB $85
	DB $0d
	DB $09
	DB $11
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $03
	DB $07
	DB $07
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $07
	DB $01
	DB $00
	DB $00
	DB $00
	DB $00
	DB $e0
	DB $f0
	DB $f0
	DB $f8
	DB $7c
	DB $7f
	DB $70
	DB $2f
	DB $b8
	DB $bf
	DB $a3
	DB $e5
	DB $f1
	DB $79
	DB $00
	DB $00
	DB $03
	DB $0f
	DB $1f
	DB $3f
	DB $3f
	DB $fe
	DB $0f
	DB $f4
	DB $1d
	DB $fd
	DB $c5
	DB $a7
	DB $8e
	DB $9c
	DB $00
	DB $00
	DB $c0
	DB $e0
	DB $c0
	DB $80
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $e0
	DB $e0
	DB $80
	DB $00
	DB $00
	DB $00
	DB $00
	DB $1e
	DB $3f
	DB $3f
	DB $7f
	DB $5b
	DB $5b
	DB $02
	DB $00
	DB $00
	DB $00
	DB $00
	DB $01
	DB $02
	DB $06
	DB $2f
	DB $22
	DB $38
	DB $5c
	DB $5e
	DB $4f
	DB $6f
	DB $77
	DB $70
	DB $3f
	DB $00
	DB $7e
	DB $fe
	DB $f8
	DB $dc
	DB $4c
	DB $ec
	DB $a4
	DB $0c
	DB $18
	DB $b8
	DB $f1
	DB $f5
	DB $ed
	DB $19
	DB $7e
	DB $7f
	DB $1f
	DB $3b
	DB $32
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $e0
	DB $f8
	DB $f8
	DB $f8
	DB $a8
	DB $a8
	DB $a8
	DB $00
	DB $80
	DB $40
	DB $60
	DB $00
	DB $00
	DB $00
	DB $00
	DB $03
	DB $07
	DB $03
	DB $01
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $07
	DB $07
	DB $01
	DB $00
	DB $00
	DB $00
	DB $00
	DB $c0
	DB $f0
	DB $f8
	DB $fc
	DB $fc
	DB $7f
	DB $f0
	DB $2f
	DB $b8
	DB $bf
	DB $a3
	DB $e5
	DB $71
	DB $39
	DB $00
	DB $00
	DB $07
	DB $0f
	DB $0f
	DB $1f
	DB $3e
	DB $fe
	DB $0e
	DB $f4
	DB $1d
	DB $fd
	DB $c5
	DB $a7
	DB $8f
	DB $9e
	DB $00
	DB $00
	DB $c0
	DB $e0
	DB $e0
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $e0
	DB $80
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $07
	DB $1f
	DB $1f
	DB $1f
	DB $15
	DB $15
	DB $15
	DB $00
	DB $01
	DB $02
	DB $06
	DB $00
	DB $00
	DB $37
	DB $25
	DB $30
	DB $18
	DB $1d
	DB $8f
	DB $af
	DB $b7
	DB $98
	DB $7e
	DB $fe
	DB $f8
	DB $dc
	DB $4c
	DB $00
	DB $00
	DB $f4
	DB $44
	DB $1c
	DB $3a
	DB $7a
	DB $f2
	DB $f6
	DB $ee
	DB $0e
	DB $fc
	DB $00
	DB $7e
	DB $7f
	DB $1f
	DB $3b
	DB $32
	DB $00
	DB $00
	DB $78
	DB $fc
	DB $fc
	DB $fe
	DB $da
	DB $da
	DB $40
	DB $00
	DB $00
	DB $00
	DB $00
	DB $80
	DB $40
	DB $60
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
	DB $00
cvb_MUSIC_BOSS:
	DB $08
	db $0a,$16,$e2,$01
	db $0a,$16,$3f,$02
	db $0a,$16,$00,$01
	db $0a,$16,$00,$02
	db $3f,$3f,$00,$01
	db $0a,$16,$00,$02
	db $3f,$3f,$00,$01
	db $0a,$16,$00,$02
	db $3f,$3f,$00,$01
	db $0a,$16,$00,$02
	db $0a,$16,$00,$01
	db $0a,$16,$00,$01
	db $08,$14,$00,$02
	db $3f,$3f,$00,$01
	db $0a,$16,$00,$02
	db $3f,$3f,$00,$00
	db $0a,$16,$00,$01
	db $0a,$16,$00,$02
	db $0a,$16,$00,$01
	db $0a,$16,$00,$02
	db $3f,$3f,$00,$01
	db $0a,$16,$00,$02
	db $3f,$3f,$00,$01
	db $0a,$16,$00,$02
	db $3f,$3f,$00,$01
	db $0a,$16,$00,$02
	db $0a,$16,$00,$01
	db $0a,$16,$00,$01
	db $0d,$19,$00,$02
	db $3f,$3f,$00,$01
	db $0f,$1b,$00,$02
	db $3f,$3f,$00,$03
	db $0a,$16,$00,$01
	db $0a,$16,$00,$02
	db $0a,$16,$00,$01
	db $0a,$16,$00,$02
	db $3f,$3f,$00,$01
	db $0a,$16,$00,$02
	db $3f,$3f,$00,$01
	db $0a,$16,$00,$02
	db $3f,$3f,$00,$01
	db $0a,$16,$00,$02
	db $0a,$16,$00,$01
	db $0a,$16,$00,$01
	db $08,$14,$00,$02
	db $3f,$3f,$00,$01
	db $0a,$16,$00,$02
	db $3f,$3f,$00,$00
	db $22,$a2,$00,$01
	db $20,$a0,$00,$01
	db $3f,$3f,$00,$00
	db $1d,$9d,$00,$01
	db $3f,$3f,$00,$00
	db $1b,$9b,$00,$01
	db $3f,$3f,$00,$00
	db $19,$99,$00,$01
	db $1b,$9b,$00,$02
	db $19,$99,$00,$01
	db $16,$96,$00,$03
	db $16,$96,$00,$02
	db $3f,$3f,$00,$02
	db $3f,$3f,$00,$02
	db $3f,$3f,$00,$02
	db $fd,$00,$00,$00
cvb_MUSIC_GAME:
	DB $05
	db $27,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$16,$00,$01
	db $2e,$3f,$00,$01
	db $3f,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $33,$16,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $27,$16,$00,$00
	db $3f,$3f,$00,$00
	db $2e,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $33,$16,$00,$00
	db $3f,$3f,$00,$00
	db $27,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $2e,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $33,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $27,$14,$00,$00
	db $3f,$3f,$00,$00
	db $2e,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $33,$14,$00,$00
	db $3f,$3f,$00,$00
	db $27,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$12,$00,$00
	db $2e,$3f,$00,$00
	db $3f,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $33,$12,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $27,$12,$00,$00
	db $3f,$3f,$00,$00
	db $2e,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $33,$12,$00,$00
	db $3f,$3f,$00,$00
	db $27,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $2e,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $33,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $27,$14,$00,$00
	db $3f,$3f,$00,$00
	db $2e,$0d,$00,$02
	db $3f,$3f,$00,$00
	db $33,$14,$00,$02
	db $3f,$3f,$00,$02
	db $27,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$16,$00,$00
	db $2e,$3f,$00,$00
	db $3f,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $33,$16,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $36,$16,$00,$00
	db $3f,$3f,$00,$00
	db $35,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $31,$16,$00,$00
	db $3f,$3f,$00,$00
	db $38,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $36,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $35,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $36,$14,$00,$00
	db $3f,$3f,$00,$00
	db $35,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $31,$14,$00,$00
	db $3f,$3f,$00,$00
	db $27,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$12,$00,$00
	db $2e,$3f,$00,$00
	db $3f,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $33,$12,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $27,$12,$00,$00
	db $3f,$3f,$00,$00
	db $2e,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $33,$12,$00,$00
	db $3f,$3f,$00,$00
	db $27,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $2e,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $33,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $27,$14,$00,$00
	db $3f,$3f,$00,$00
	db $2e,$0d,$00,$02
	db $3f,$3f,$00,$00
	db $33,$14,$00,$02
	db $3f,$3f,$00,$02
	db $1b,$0f,$00,$01
	db $1b,$3f,$00,$00
	db $1b,$16,$00,$00
	db $3f,$3f,$00,$00
	db $1b,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $19,$16,$00,$00
	db $1b,$3f,$00,$00
	db $3f,$0f,$00,$01
	db $1b,$3f,$00,$00
	db $3f,$16,$00,$00
	db $3f,$3f,$00,$00
	db $1e,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $1d,$16,$00,$00
	db $3f,$3f,$00,$00
	db $20,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $1e,$14,$00,$00
	db $3f,$3f,$00,$00
	db $1d,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $19,$14,$00,$00
	db $3f,$3f,$00,$00
	db $17,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $3f,$3f,$00,$00
	db $17,$0b,$00,$01
	db $17,$3f,$00,$00
	db $17,$12,$00,$00
	db $3f,$3f,$00,$00
	db $17,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $16,$12,$00,$00
	db $17,$3f,$00,$00
	db $3f,$0b,$00,$01
	db $17,$3f,$00,$00
	db $3f,$12,$00,$00
	db $3f,$3f,$00,$00
	db $17,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $17,$12,$00,$00
	db $3f,$3f,$00,$00
	db $19,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $19,$14,$00,$00
	db $3f,$3f,$00,$00
	db $19,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $17,$14,$00,$00
	db $19,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$02
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$02
	db $3f,$3f,$00,$02
	db $1b,$0f,$00,$01
	db $1b,$3f,$00,$00
	db $1b,$16,$00,$00
	db $3f,$3f,$00,$00
	db $1b,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $19,$16,$00,$00
	db $1b,$3f,$00,$00
	db $3f,$0f,$00,$01
	db $1b,$3f,$00,$00
	db $3f,$16,$00,$00
	db $3f,$3f,$00,$00
	db $1e,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $1d,$16,$00,$00
	db $3f,$3f,$00,$00
	db $20,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $1e,$14,$00,$00
	db $3f,$3f,$00,$00
	db $1d,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $19,$14,$00,$00
	db $3f,$3f,$00,$00
	db $17,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $3f,$3f,$00,$00
	db $17,$0b,$00,$01
	db $17,$3f,$00,$00
	db $17,$12,$00,$00
	db $3f,$3f,$00,$00
	db $17,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $16,$12,$00,$00
	db $17,$3f,$00,$00
	db $3f,$0b,$00,$01
	db $17,$3f,$00,$00
	db $3f,$12,$00,$00
	db $3f,$3f,$00,$00
	db $17,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $17,$12,$00,$00
	db $3f,$3f,$00,$00
	db $19,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $1b,$14,$00,$00
	db $3f,$3f,$00,$00
	db $1d,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $1e,$14,$00,$00
	db $3f,$3f,$00,$00
	db $20,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$02
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$02
	db $3f,$3f,$00,$02
	db $27,$0f,$00,$01
	db $29,$3f,$00,$00
	db $2a,$16,$00,$00
	db $2c,$3f,$00,$00
	db $2e,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$16,$00,$00
	db $27,$3f,$00,$00
	db $3f,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $2e,$16,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $27,$16,$00,$00
	db $3f,$3f,$00,$00
	db $25,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $27,$14,$00,$00
	db $3f,$3f,$00,$00
	db $29,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $25,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $22,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$12,$00,$00
	db $3f,$3f,$00,$00
	db $23,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$12,$00,$00
	db $25,$3f,$00,$00
	db $3f,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $27,$12,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $27,$12,$00,$00
	db $3f,$3f,$00,$00
	db $29,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $2a,$14,$00,$00
	db $3f,$3f,$00,$00
	db $29,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $2a,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $2c,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$02
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$02
	db $3f,$3f,$00,$02
	db $27,$0f,$00,$01
	db $29,$3f,$00,$00
	db $2a,$16,$00,$00
	db $2c,$3f,$00,$00
	db $2e,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$16,$00,$00
	db $27,$3f,$00,$00
	db $27,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $2e,$16,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $36,$16,$00,$00
	db $3f,$3f,$00,$00
	db $35,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $31,$14,$00,$00
	db $3f,$3f,$00,$00
	db $38,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $36,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $35,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $36,$14,$00,$00
	db $3f,$3f,$00,$00
	db $35,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $31,$12,$00,$00
	db $3f,$3f,$00,$00
	db $23,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$12,$00,$00
	db $1e,$3f,$00,$00
	db $3f,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $1b,$12,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $17,$12,$00,$00
	db $3f,$3f,$00,$00
	db $1b,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $1e,$14,$00,$00
	db $3f,$3f,$00,$00
	db $1d,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $19,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $20,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$02
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$02
	db $3f,$3f,$00,$02
	db $1b,$0f,$00,$01
	db $1b,$3f,$00,$00
	db $1b,$16,$00,$00
	db $3f,$3f,$00,$00
	db $1b,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $19,$16,$00,$00
	db $1b,$3f,$00,$00
	db $3f,$0f,$00,$01
	db $1b,$3f,$00,$00
	db $3f,$16,$00,$00
	db $3f,$3f,$00,$00
	db $1e,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $1d,$16,$00,$00
	db $3f,$3f,$00,$00
	db $20,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $1e,$14,$00,$00
	db $3f,$3f,$00,$00
	db $1d,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $19,$14,$00,$00
	db $3f,$3f,$00,$00
	db $17,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $3f,$3f,$00,$00
	db $17,$0b,$00,$01
	db $17,$3f,$00,$00
	db $17,$12,$00,$00
	db $3f,$3f,$00,$00
	db $17,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $16,$12,$00,$00
	db $17,$3f,$00,$00
	db $3f,$0b,$00,$01
	db $17,$3f,$00,$00
	db $3f,$12,$00,$00
	db $3f,$3f,$00,$00
	db $17,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $17,$12,$00,$00
	db $3f,$3f,$00,$00
	db $19,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $19,$14,$00,$00
	db $3f,$3f,$00,$00
	db $19,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $17,$14,$00,$00
	db $19,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$02
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$02
	db $3f,$3f,$00,$02
	db $27,$0f,$00,$01
	db $27,$3f,$00,$00
	db $27,$16,$00,$00
	db $3f,$3f,$00,$00
	db $27,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $25,$16,$00,$00
	db $27,$3f,$00,$00
	db $3f,$0f,$00,$01
	db $27,$3f,$00,$00
	db $3f,$16,$00,$00
	db $3f,$3f,$00,$00
	db $2a,$0f,$00,$01
	db $3f,$3f,$00,$00
	db $29,$16,$00,$00
	db $3f,$3f,$00,$00
	db $2c,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $2a,$14,$00,$00
	db $3f,$3f,$00,$00
	db $29,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $25,$14,$00,$00
	db $3f,$3f,$00,$00
	db $23,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $3f,$3f,$00,$00
	db $23,$0b,$00,$01
	db $23,$3f,$00,$00
	db $23,$12,$00,$00
	db $3f,$3f,$00,$00
	db $23,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $22,$12,$00,$00
	db $23,$3f,$00,$00
	db $3f,$0b,$00,$01
	db $23,$3f,$00,$00
	db $3f,$12,$00,$00
	db $3f,$3f,$00,$00
	db $23,$0b,$00,$01
	db $3f,$3f,$00,$00
	db $23,$12,$00,$00
	db $3f,$3f,$00,$00
	db $25,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $25,$14,$00,$00
	db $3f,$3f,$00,$00
	db $25,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $20,$14,$00,$00
	db $25,$3f,$00,$00
	db $3f,$0d,$00,$01
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$00
	db $3f,$3f,$00,$00
	db $3f,$0d,$00,$02
	db $3f,$3f,$00,$00
	db $3f,$14,$00,$02
	db $3f,$3f,$00,$02
	db $fd,$00,$00,$00
cvb_MUSIC_TITLE:
	DB $05
	db $1d,$0a,$00,$01
	db $3f,$00,$00,$00
	db $22,$16,$00,$00
	db $3f,$00,$00,$00
	db $25,$0a,$00,$02
	db $3f,$00,$00,$00
	db $22,$16,$00,$00
	db $3f,$00,$00,$00
	db $3f,$0a,$00,$01
	db $3f,$00,$00,$00
	db $00,$16,$00,$00
	db $00,$00,$00,$00
	db $00,$0a,$00,$02
	db $00,$00,$00,$00
	db $00,$16,$00,$02
	db $00,$00,$00,$02
	db $25,$0a,$00,$01
	db $3f,$00,$00,$00
	db $29,$16,$00,$00
	db $3f,$00,$00,$00
	db $2e,$0a,$00,$02
	db $3f,$00,$00,$00
	db $29,$16,$00,$00
	db $3f,$00,$00,$00
	db $3f,$0a,$00,$01
	db $3f,$00,$00,$00
	db $00,$16,$00,$00
	db $00,$00,$00,$00
	db $27,$0a,$00,$02
	db $3f,$00,$00,$00
	db $25,$16,$00,$02
	db $3f,$00,$00,$02
	db $24,$08,$00,$01
	db $3f,$00,$00,$00
	db $3f,$14,$00,$00
	db $3f,$00,$00,$00
	db $3f,$08,$00,$02
	db $3f,$00,$00,$00
	db $20,$14,$00,$00
	db $3f,$00,$00,$00
	db $3f,$08,$00,$01
	db $3f,$00,$00,$00
	db $3f,$14,$00,$00
	db $3f,$00,$00,$00
	db $24,$08,$00,$02
	db $3f,$00,$00,$00
	db $3f,$14,$00,$02
	db $3f,$00,$00,$02
	db $3f,$08,$00,$01
	db $3f,$00,$00,$00
	db $3f,$14,$00,$00
	db $3f,$00,$00,$00
	db $3f,$08,$00,$01
	db $3f,$00,$00,$00
	db $3f,$14,$00,$00
	db $3f,$00,$00,$00
	db $3f,$08,$00,$02
	db $3f,$00,$00,$00
	db $24,$14,$00,$02
	db $3f,$00,$00,$02
	db $25,$08,$00,$02
	db $3f,$00,$00,$00
	db $24,$14,$00,$02
	db $3f,$00,$00,$02
	db $22,$0a,$00,$01
	db $3f,$00,$00,$00
	db $3f,$16,$00,$00
	db $3f,$00,$00,$00
	db $3f,$0a,$00,$02
	db $3f,$00,$00,$00
	db $3f,$16,$00,$00
	db $3f,$00,$00,$00
	db $3f,$0a,$00,$01
	db $3f,$00,$00,$00
	db $00,$16,$00,$00
	db $00,$00,$00,$00
	db $00,$0a,$00,$02
	db $00,$00,$00,$00
	db $00,$16,$00,$02
	db $00,$00,$00,$02
	db $00,$0a,$00,$01
	db $00,$00,$00,$00
	db $00,$16,$00,$00
	db $00,$00,$00,$00
	db $00,$0a,$00,$02
	db $00,$00,$00,$00
	db $00,$16,$00,$00
	db $00,$00,$00,$00
	db $00,$0a,$00,$01
	db $00,$00,$00,$00
	db $00,$16,$00,$00
	db $00,$00,$00,$00
	db $00,$0a,$00,$02
	db $00,$00,$00,$00
	db $00,$16,$00,$02
	db $00,$00,$00,$02
	db $fd,$00,$00,$00
cvb_PLAY_SOUND:
	LD A,(cvb_SOUND_EFFECT)
	CP 6
	JP NC,cv124
	LD DE,cv124
	PUSH DE
	LD L,A
	LD H,0
	ADD HL,HL
	LD DE,cv123
	ADD HL,DE
	LD A,(HL)
	INC HL
	LD H,(HL)
	LD L,A
	JP (HL)
cv123:
	DW cvb_SOUND_NONE
	DW cvb_SOUND_SHOOT1
	DW cvb_SOUND_SHOOT2
	DW cvb_SOUND_HIT1
	DW cvb_SOUND_HIT2
	DW cvb_SOUND_BOSS
cv124:
	RET
cvb_SOUND_NONE:
	SUB A
	LD B,$d0
	CALL sn76489_vol
	SUB A
	LD B,$0a
	CALL ay3_reg
	RET
cvb_SOUND_SHOOT1:
	LD A,(cvb_SOUND_STATE)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	PUSH HL
	LD HL,128
	POP DE
	OR A
	SBC HL,DE
	LD A,$c0
	CALL sn76489_freq
	LD A,12
	LD B,$d0
	CALL sn76489_vol
	LD A,(cvb_SOUND_STATE)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	PUSH HL
	LD HL,128
	POP DE
	OR A
	SBC HL,DE
	LD A,$04
	CALL ay3_freq
	LD A,12
	LD B,$0a
	CALL ay3_reg
	LD A,(cvb_SOUND_STATE)
	INC A
	LD (cvb_SOUND_STATE),A
	CP 16
	JP NZ,cv125
	SUB A
	LD (cvb_SOUND_EFFECT),A
cv125:
	RET
cvb_SOUND_SHOOT2:
	LD A,(cvb_SOUND_STATE)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	PUSH HL
	LD HL,320
	POP DE
	OR A
	SBC HL,DE
	LD A,$c0
	CALL sn76489_freq
	LD A,12
	LD B,$d0
	CALL sn76489_vol
	LD A,(cvb_SOUND_STATE)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	PUSH HL
	LD HL,320
	POP DE
	OR A
	SBC HL,DE
	LD A,$04
	CALL ay3_freq
	LD A,12
	LD B,$0a
	CALL ay3_reg
	LD A,(cvb_SOUND_STATE)
	INC A
	LD (cvb_SOUND_STATE),A
	CP 8
	JP NZ,cv126
	SUB A
	LD (cvb_SOUND_EFFECT),A
cv126:
	RET
cvb_SOUND_HIT1:
	LD A,(cvb_SOUND_STATE)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	LD DE,640
	ADD HL,DE
	LD A,$c0
	CALL sn76489_freq
	LD A,12
	LD B,$d0
	CALL sn76489_vol
	LD A,(cvb_SOUND_STATE)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	PUSH HL
	LD HL,640
	POP DE
	OR A
	SBC HL,DE
	LD A,$04
	CALL ay3_freq
	LD A,12
	LD B,$0a
	CALL ay3_reg
	LD A,(cvb_SOUND_STATE)
	INC A
	LD (cvb_SOUND_STATE),A
	CP 8
	JP NZ,cv127
	SUB A
	LD (cvb_SOUND_EFFECT),A
cv127:
	RET
cvb_SOUND_HIT2:
	LD A,(cvb_SOUND_STATE)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	LD DE,320
	ADD HL,DE
	LD A,$c0
	CALL sn76489_freq
	LD A,12
	LD B,$d0
	CALL sn76489_vol
	LD A,(cvb_SOUND_STATE)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	LD DE,320
	ADD HL,DE
	LD A,$04
	CALL ay3_freq
	LD A,12
	LD B,$0a
	CALL ay3_reg
	LD A,(cvb_SOUND_STATE)
	INC A
	LD (cvb_SOUND_STATE),A
	CP 16
	JP NZ,cv128
	SUB A
	LD (cvb_SOUND_EFFECT),A
cv128:
	RET
cvb_SOUND_BOSS:
	LD A,(cvb_SOUND_STATE)
	LD L,A
	LD H,0
	LD A,L
	AND 1
	LD L,A
	LD H,0
	LD A,H
	OR L
	JP Z,cv129
	LD A,(cvb_SOUND_STATE)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	LD DE,320
	ADD HL,DE
	LD A,$c0
	CALL sn76489_freq
	LD A,12
	LD B,$d0
	CALL sn76489_vol
	LD A,(cvb_SOUND_STATE)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	LD DE,320
	ADD HL,DE
	LD A,$04
	CALL ay3_freq
	LD A,12
	LD B,$0a
	CALL ay3_reg
	JP cv130
cv129:
	LD A,(cvb_SOUND_STATE)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	PUSH HL
	LD HL,320
	POP DE
	OR A
	SBC HL,DE
	LD A,$c0
	CALL sn76489_freq
	LD A,12
	LD B,$d0
	CALL sn76489_vol
	LD A,(cvb_SOUND_STATE)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	PUSH HL
	LD HL,320
	POP DE
	OR A
	SBC HL,DE
	LD A,$04
	CALL ay3_freq
	LD A,12
	LD B,$0a
	CALL ay3_reg
cv130:
	LD A,(cvb_SOUND_STATE)
	INC A
	LD (cvb_SOUND_STATE),A
	CP 32
	JP NZ,cv131
	SUB A
	LD (cvb_SOUND_EFFECT),A
cv131:
	RET
CVBASIC_MUSIC_PLAYER:	equ 1
CVBASIC_COMPRESSION:	equ 1
	;
	; CVBasic epilogue (BASIC compiler for Colecovision)
	;
	; by Oscar Toledo G.
	; https://nanochess.org/
	;
	; Creation date: Feb/27/2024.
	; Revision date: Feb/29/2024. Added joystick, keypad, frame, random, and
	;                             read_pointer variables.
	; Revision date: Mar/04/2024. Added music player.
	; Revision date: Mar/05/2024. Added support for Sega SG1000.
	; Revision date: Mar/12/2024. Added support for MSX.
	; Revision date: Mar/13/2024. Added Pletter decompressor.
	;

nmi_handler:
	push af
	push hl
	ld hl,mode
	bit 0,(hl)
	jr z,.1
	set 1,(hl)
	pop hl
	pop af
	retn

.0:	res 1,(hl)

.1:	push bc
	push de
    if SG1000+MSX
	in a,(VDP+1)
    endif
	ld hl,$1b00
	call SETWRT
	ld hl,sprites
	ld bc,$8000+VDP
	outi
	jp nz,$-2

    if COLECO
	out (JOYSEL),a
	ex (sp),hl
	ex (sp),hl
	in a,(JOY1)
	or $b0
	ld b,a
	in a,(JOY2)
	or $b0
	ld c,a

	out (KEYSEL),a
	ex (sp),hl
	ex (sp),hl
	in a,(JOY1)
	ld d,a
	in a,(JOY2)
	ld e,a

	ld a,d
	rlca
	or $7f
	and b
	cpl
	ld (joy1_data),a

	ld a,e
	rlca
	or $7f
	and c
	cpl
	ld (joy2_data),a

	ld a,d
	and $0f
	ld c,a
	ld b,0
	ld hl,keypad_table
	add hl,bc
	ld a,(hl)
	ld (key1_data),a

	ld a,e
	and $0f
	ld c,a
	ld hl,keypad_table
	add hl,bc
	ld a,(hl)
	ld (key2_data),a
    endif
    if SG1000
        ld b,$ff
        in a,(JOY1)
        bit 0,a
        jr nz,$+4
        res 0,b
        bit 1,a
        jr nz,$+4
        res 2,b
        bit 2,a
        jr nz,$+4
        res 3,b
        bit 3,a
        jr nz,$+4
        res 1,b
        bit 4,a
        jr nz,$+4
        res 6,b
        bit 5,a
        jr nz,$+4
        res 7,b
	push af
	ld a,b
	cpl
	ld (joy1_data),a
	pop af

	ld b,$ff
        bit 6,a
        jr nz,$+4
        res 0,b
        bit 7,a
        jr nz,$+4
        res 2,b

        in a,(JOY2)
        bit 0,a
        jr nz,$+4
        res 3,b
        bit 1,a
        jr nz,$+4
        res 1,b
        bit 2,a
        jr nz,$+4
        res 4,b
        bit 3,a
        jr nz,$+4
        res 5,b
	push af
	ld a,b
	cpl
	ld (joy2_data),a
	pop af

    endif
    if MSX

	ld a,15
	call RDPSG
	and $b0
	or $4f
	ld e,a
	ld a,15
	call WRTPSG
	ld a,14
	call RDPSG
	ld b,$ff
	bit 0,a
	jr nz,$+4
	res 0,b
	bit 3,a
	jr nz,$+4
	res 1,b
	bit 1,a
	jr nz,$+4
	res 2,b
	bit 2,a
	jr nz,$+4
	res 3,b
	bit 4,a
	jr nz,$+4
	res 6,b
	bit 5,a
	jr nz,$+4
	res 7,b
	ld a,b
	cpl
	ld (joy2_data),a

        ld b,$ff
	in a,($aa)
	and $f0
	or $08
	out ($aa),a
	in a,($a9)
	bit 5,a
	jr nz,$+4
        res 0,b
	bit 7,a
	jr nz,$+4
        res 1,b
        bit 6,a
        jr nz,$+4
        res 2,b
        bit 4,a
        jr nz,$+4
        res 3,b
	bit 0,a
	jr nz,$+4
	res 6,b
	in a,($aa)
	and $f0
	or $04
	out ($aa),a
	in a,($a9)
	bit 2,a
	jr nz,$+4
	res 7,b

	ld a,15
	call RDPSG
	and $b0
	or $0f
	ld e,a
	ld a,15
	call WRTPSG
	ld a,14
	call RDPSG
	bit 0,a
	jr nz,$+4
	res 0,b
	bit 3,a
	jr nz,$+4
	res 1,b
	bit 1,a
	jr nz,$+4
	res 2,b
	bit 2,a
	jr nz,$+4
	res 3,b
	bit 4,a
	jr nz,$+4
	res 6,b
	bit 5,a
	jr nz,$+4
	res 7,b

	ld a,b
	cpl
	ld (joy1_data),a
    endif

    if CVBASIC_MUSIC_PLAYER
	ld a,(music_mode)
	or a
	call nz,music_hardware
    endif

	ld hl,(frame)
	inc hl
	ld (frame),hl

    if CVBASIC_MUSIC_PLAYER
	;
	; Music is played with a 50hz clock.
	;
	ld a,(ntsc)
	or a
	jr z,.2
	ld a,(music_tick)
	inc a
	cp 6
	jr nz,$+3
	xor a
	ld (music_tick),a
	jr z,.3
.2:
	ld a,(music_mode)
	or a
	call nz,music_generate
.3:
    endif
	CALL cvb_PLAY_SOUND

	pop de
	pop bc
	pop hl
    if COLECO
	in a,(VDP+1)
	pop af
	retn
    endif
    if SG1000
	pop af
        ei
        reti
    endif
    if MSX
	pop af
        ret
    endif

	;
	; The music player code comes from my
	; game Princess Quest for Colecovision (2012)
	;

        ;
        ; Init music player.
        ;
music_init:
    if COLECO+SG1000
        ld a,$9f
        out (PSG),a
        ld a,$bf
        out (PSG),a
        ld a,$df
        out (PSG),a
        ld a,$ff
        out (PSG),a
        ld a,$ec
        out (PSG),a
    endif
    if MSX
WRTPSG:	equ $0093
RDPSG:	equ $0096

	ld a,$08
	ld e,$00
	call WRTPSG
	ld a,$09
	ld e,$00
	call WRTPSG
	ld a,$0a
	ld e,$00
	call WRTPSG
	ld a,$07
	ld e,$b8
	call WRTPSG
    endif
    if CVBASIC_MUSIC_PLAYER
    else
	ret
    endif

    if CVBASIC_MUSIC_PLAYER
        ld a,$ff
        ld (audio_vol4hw),a
        ld a,$ec
        ld (audio_control),a
        ld a,$b8
        ld (audio_mix),a
	ld hl,music_silence
        ;
	; Play a music.
	; HL = Pointer to music.
        ;
music_play:
        call nmi_off
        ld a,(hl)          
        ld (music_timing),a
        inc hl
        ld (music_start),hl
        ld (music_pointer),hl
        xor a
        ld (music_note_counter),a
	inc a
	ld (music_playing),a
        jp nmi_on

        ;
        ; Reads 4 bytes.
        ;
music_four:
        ld b,(hl)
        inc hl
        ld c,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld e,(hl)
        ret

        ;
        ; Generates music.
        ;
music_generate:
        ld a,(audio_mix)
        and $c0                 
        or $38
        ld (audio_mix),a
        xor a                ; Turn off all the sound channels.
        ld l,a
        ld h,a
        ld (audio_vol1),hl   ; audio_vol1/audio_vol2
        ld (audio_vol3),a
	ld a,$ff
	ld (audio_vol4hw),a

        ld a,(music_note_counter)
        or a
        jp nz,.6
        ld hl,(music_pointer)
.15:    push hl
        call music_four
        pop hl
        ld a,(music_timing)
        rlca
        jr nc,.16
        ld e,d
        ld d,0
        jr .17

.16:    rlca
        jr nc,.17
        ld e,0
.17:    ld a,b		; Read first byte.
        cp -2           ; End of music?
        jr nz,.19       ; No, jump.
        xor a		; Keep at same place.
        ld (music_playing),a
        ret

.19:    cp -3           ; Repeat music?
        jp nz,.0
        ld hl,(music_start)
        jr .15

.0:     ld a,(music_timing)
        and $3f         ; Restart note time.
        ld (music_note_counter),a
        ld a,b
        cp $3f          ; Sustain?
        jr z,.1
        rlca
        rlca
        and 3
        ld (music_instrument_1),a    
        ld a,b
        and $3f
        ld (music_note_1),a    
        xor a         
        ld (music_counter_1),a    
.1:     ld a,c          
        cp $3f          
        jr z,.2
        rlca
        rlca
        and 3
        ld (music_instrument_2),a    
        ld a,c
        and $3f
        ld (music_note_2),a    
        xor a         
        ld (music_counter_2),a    
.2:     ld a,d          
        cp $3f          
        jr z,.3
        rlca
        rlca
        and 3
        ld (music_instrument_3),a    
        ld a,d
        and $3f
        ld (music_note_3),a    
        xor a         
        ld (music_counter_3),a    
.3:     ld a,e          
        ld (music_drum),a
        xor a
        ld (music_counter_4),a
        inc hl
        inc hl
        inc hl
        ld a,(music_timing)
        and $c0
        jr nz,.14
        inc hl
.14:    ld (music_pointer),hl

.6:     ld a,(music_note_1)    
        or a            
        jr z,.7         
        ld bc,(music_instrument_1)
        call music_note2freq
        ld (audio_freq1),hl 
        ld (audio_vol1),a

.7:     ld a,(music_note_2)    
        or a            
        jr z,.8         
        ld bc,(music_instrument_2)
        call music_note2freq
        ld (audio_freq2),hl 
        ld (audio_vol2),a

.8:     ld a,(music_note_3)    
        or a            
        jr z,.9         
        ld bc,(music_instrument_3)
        call music_note2freq
        ld (audio_freq3),hl 
        ld (audio_vol3),a

.9:     ld a,(music_drum)    
        or a            
        jr z,.4         
        dec a           ; 1 - Long drum.
        jr nz,.5
        ld a,(music_counter_4)
        cp 3
        jp nc,.4
.10:    ld a,5
        ld (audio_noise),a
        call enable_drum
        jr .4

.5:     dec a           ; 2 - Short durm.
        jr nz,.11
        ld a,(music_counter_4)
        or a
        jp nz,.4
        ld a,8
        ld (audio_noise),a
        call enable_drum
        jr .4

.11:    ;dec a           ; 3 - Roll.
        ;jp nz,.4
        ld a,(music_timing)
        and $3e
        rrca
        ld b,a
        ld a,(music_counter_4)
        cp 2
        jp c,.10
        cp b
        jp c,.4
        dec a
        dec a
        cp b
        jp c,.10
.4:
        ld a,(music_counter_1)
        inc a
        cp $18
        jp nz,$+5
        sub $08
        ld (music_counter_1),a

        ld a,(music_counter_2)
        inc a
        cp $18
        jp nz,$+5
        sub $08
        ld (music_counter_2),a

        ld a,(music_counter_3)
        inc a
        cp $18
        jp nz,$+5
        sub $08
        ld (music_counter_3),a

        ld hl,music_counter_4
        inc (hl)
        ld hl,music_note_counter
        dec (hl)
        ret

        ;
        ; Converts note to frequency.
 	; Input:
	;   A = Note (1-62).
	;   B = Instrument counter.
	;   C = Instrument.
        ; Output:
	;   HL = Frequency.
	;   A = Volume.
	;
music_note2freq:
        add a,a
        ld e,a
        ld d,0
        ld hl,music_notes_table
        add hl,de
        ld a,(hl)
        inc hl
        ld h,(hl)
        ld l,a
        ld a,c
        or a
        jp z,music_piano
        dec a
        jp z,music_clarinet
        dec a
        jp z,music_flute
        ;
        ; Bass instrument.
        ;
music_bass:
        add hl,hl

        ;
        ; Piano instrument.
        ;
music_piano:
        ld a,b
        add a,.1&255
        ld c,a
        adc a,.1>>8
        sub c
        ld b,a
        ld a,(bc)
        ret

.1:
        db 12,11,11,10,10,9,9,8
        db 8,7,7,6,6,5,5,4
        db 4,4,5,5,4,4,3,3

        ;
        ; Clarinet instrument.
        ;
music_clarinet:
        ld a,b
        add a,.1&255
        ld c,a
        adc a,.1>>8
        sub c
        ld b,a
        ld a,(bc)
        ld e,a
        rlca
        sbc a,a
        ld d,a
        add hl,de
        srl h           
        rr l
        jp nc,.2
        inc hl
.2:     ld a,c
        add a,24
        ld c,a
	jr nc,$+3
	inc b
        ld a,(bc)
        ret

.1:
        db 0,0,0,0
        db -2,-4,-2,0
        db 2,4,2,0
        db -2,-4,-2,0
        db 2,4,2,0
        db -2,-4,-2,0

        db 13,14,14,13,13,12,12,12
        db 11,11,11,11,12,12,12,12
        db 11,11,11,11,12,12,12,12

        ;
        ; Flute instrument.
        ;
music_flute:
        ld a,b
        add a,.1&255
        ld c,a
        adc a,.1>>8
        sub c
        ld b,a
        ld a,(bc)
        ld e,a
        rlca
        sbc a,a
        ld d,a
        add hl,de
        ld a,c
        add a,24
        ld c,a
	jr nc,$+3
	inc b
        ld a,(bc)
        ret

.1:
        db 0,0,0,0
        db 0,1,2,1
        db 0,1,2,1
        db 0,1,2,1
        db 0,1,2,1
        db 0,1,2,1
                 
        db 10,12,13,13,12,12,12,12
        db 11,11,11,11,10,10,10,10
        db 11,11,11,11,10,10,10,10

        ;
        ; Emit sound.
        ;
music_hardware:
    if COLECO+SG1000
	ld a,(music_mode)
	cp 4		; PLAY SIMPLE?
	jr c,.7		; Yes, jump.
        ld a,(audio_vol2)
        or a
        jp nz,.7
        ld a,(audio_vol3)
        or a
        jp z,.7
        ld (audio_vol2),a
        xor a
        ld (audio_vol3),a
        ld hl,(audio_freq3)
        ld (audio_freq2),hl
.7:
        ld hl,(audio_freq1)
        ld a,h
        cp 4
        ld a,$9f
        jp nc,.1
        ld a,l
        and $0f
        or $80
        out (PSG),a
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,hl
        ld a,h
        out (PSG),a
        ld a,(audio_vol1)
        add a,ay2sn&255
        ld l,a
        adc a,ay2sn>>8
        sub l
        ld h,a
        ld a,(hl)
        or $90
.1:     out (PSG),a

        ld hl,(audio_freq2)
        ld a,h
        cp 4
        ld a,$bf
        jp nc,.2
        ld a,l
        and $0f
        or $a0
        out (PSG),a
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,hl
        ld a,h
        out (PSG),a
        ld a,(audio_vol2)
        add a,ay2sn&255
        ld l,a
        adc a,ay2sn>>8
        sub l
        ld h,a
        ld a,(hl)
        or $b0
.2:     out (PSG),a

	ld a,(music_mode)
	cp 4		; PLAY SIMPLE?
	jr c,.6		; Yes, jump.

        ld hl,(audio_freq3)
        ld a,h
        cp 4
        ld a,$df
        jp nc,.3
        ld a,l
        and $0f
        or $c0
        out (PSG),a
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,hl
        ld a,h
        out (PSG),a
        ld a,(audio_vol3)
        add a,ay2sn&255
        ld l,a
        adc a,ay2sn>>8
        sub l
        ld h,a
        ld a,(hl)
        or $d0
.3:     out (PSG),a

.6:
	ld a,(music_mode)
	and 1		; NO DRUMS?
	ret z		; Yes, return.

        ld a,(audio_vol4hw)
        inc a           
        jr z,.4        
        ld a,(audio_noise)
        cp 16
        ld b,$ec        
        jp c,.5
        ld b,$ed        
;       ld b,$ee        
.5:     ld a,(audio_control)
        cp b
        jr z,.4
        ld a,b
        ld (audio_control),a
        out (PSG),a
.4:     ld a,(audio_vol4hw)
        out (PSG),a
        ret
    endif
    if MSX
	ld a,(music_mode)
	cp 4		; PLAY SIMPLE?
	jr c,.8		; Yes, jump.	
	ld hl,audio_freq1
	ld bc,$0b00
	ld a,c
	ld e,(hl)
	call WRTPSG
	inc hl
	inc c
	djnz $-7
	ret
.8:
	ld hl,audio_freq1
	ld bc,$0400
	ld a,c
	ld e,(hl)
	call WRTPSG
	inc hl
	inc c
	djnz $-7
	inc hl
	inc hl
	inc c
	inc c
	ld a,(music_mode)
	and 1
	jr z,.9
	ld a,c
	ld e,(hl)
	call WRTPSG
	inc hl
	inc c
	ld a,c
	ld e,(hl)
	call WRTPSG
	inc hl
	inc c
	jr .10
.9:	inc hl
	inc c
	inc hl
	inc c
.10:	ld b,$02
	ld a,c
	ld e,(hl)
	call WRTPSG
	inc hl
	inc c
	djnz $-7
	ret
    endif

        ;
        ; Enable drum.
        ;
enable_drum:
    if COLECO+SG1000
        ld a,$f5
        ld (audio_vol4hw),a
    else
        ld hl,audio_mix
        ld a,(audio_vol2)
        or a
        jr nz,.1
        ld a,10
        ld (audio_vol2),a
        set 1,(hl)
.1:     res 4,(hl)
    endif
        ret

        ;
	; Musical notes table.
	;
music_notes_table:
        ; Silence - 0
        dw 0
        ; 2nd octave - 1
        dw 1721,1621,1532,1434,1364,1286,1216,1141,1076,1017,956,909
        ; 3rd octave - 13
        dw 854,805,761,717,678,639,605,571,538,508,480,453
        ; 4th octave - 25
        dw 427,404,380,360,339,321,302,285,270,254,240,226
        ; 5th octave - 37
        dw 214,202,191,180,170,160,151,143,135,127,120,113
        ; 6th octave - 49
        dw 107,101,95,90,85,80,76,71,67,64,60,57
        ; 7th octave - 61
	dw 54,51,48

    if COLECO+SG1000
        ;
        ; Converts AY-3-8910 volume to SN76489
        ;
ay2sn:
        db $0f,$0f,$0f,$0e,$0e,$0e,$0d,$0b,$0a,$08,$07,$05,$04,$03,$01,$00
    endif

music_silence:
	db 8
	db 0,0,0,0
	db -2
    endif

    if CVBASIC_COMPRESSION
define_char_unpack:
	ex de,hl
	pop af
	pop hl
	push af
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ex de,hl
	ld a,(mode)
	and 4
	jp z,unpack3
	jp unpack

define_color_unpack:
	ex de,hl
	pop af
	pop hl
	push af
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ex de,hl
	set 5,d
unpack3:
	call .1
	call .1
.1:
	push de
	push hl
	call unpack
	pop hl
	pop de
	ld a,d
	add a,8	
	ld d,a
	ret
	
        ;
        ; Pletter-0.5c decompressor (XL2S Entertainment & Team Bomba)
        ;
unpack:
; Initialization
        ld a,(hl)
        inc hl
	exx
        ld de,0
        add a,a
        inc a
        rl e
        add a,a
        rl e
        add a,a
        rl e
        rl e
        ld hl,.modes
        add hl,de
        ld c,(hl)
        inc hl
        ld b,(hl)
        push bc
        pop ix
        ld e,1
	exx
        ld iy,.loop

; Main depack loop
.literal:
        ex af,af'
        call nmi_off
        ld a,(hl)
        ex de,hl
        call WRTVRM
        ex de,hl
        inc hl
        inc de
        call nmi_on
        ex af,af'
.loop:   add a,a
        call z,.getbit
        jr nc,.literal

; Compressed data
	exx
        ld h,d
        ld l,e
.getlen: add a,a
        call z,.getbitexx
        jr nc,.lenok
.lus:    add a,a
        call z,.getbitexx
        adc hl,hl
        ret c   
        add a,a
        call z,.getbitexx
        jr nc,.lenok
        add a,a
        call z,.getbitexx
        adc hl,hl
        ret c  
        add a,a
        call z,.getbitexx
        jr c,.lus
.lenok:  inc hl
	exx
        ld c,(hl)
        inc hl
        ld b,0
        bit 7,c
        jr z,.offsok
        jp (ix)

.mode6:  add a,a
        call z,.getbit
        rl b
.mode5:  add a,a
        call z,.getbit
        rl b
.mode4:  add a,a
        call z,.getbit
        rl b
.mode3:  add a,a
        call z,.getbit
        rl b
.mode2:  add a,a
        call z,.getbit
        rl b
        add a,a
        call z,.getbit
        jr nc,.offsok
        or a
        inc b
        res 7,c
.offsok: inc bc
        push hl
	exx
        push hl
	exx
        ld l,e
        ld h,d
        sbc hl,bc
        pop bc
        ex af,af'
.loop2: 
        call nmi_off
        call RDVRM              ; unpack
        ex de,hl
        call WRTVRM
        ex de,hl        ; 4
        call nmi_on
        inc hl          ; 6
        inc de          ; 6
        dec bc          ; 6
        ld a,b          ; 4
        or c            ; 4
        jr nz,.loop2     ; 10
        ex af,af'
        pop hl
        jp (iy)

.getbit: ld a,(hl)
        inc hl
	rla
	ret

.getbitexx:
	exx
        ld a,(hl)
        inc hl
	exx
	rla
	ret

.modes:
        dw      .offsok
        dw      .mode2
        dw      .mode3
        dw      .mode4
        dw      .mode5
        dw      .mode6

    endif

	org BASE_RAM

sprites:
	rb 128
sprite_data:
	rb 4
frame:
	rb 2
read_pointer:
	rb 2
cursor:
	rb 2
lfsr:
	rb 2
mode:
	rb 1
joy1_data:
	rb 1
joy2_data:
	rb 1
key1_data:
	rb 1
key2_data:
	rb 1
ntsc:
	rb 1

    if CVBASIC_MUSIC_PLAYER
music_tick:             rb 1
music_mode:             rb 1

music_start:		rb 2
music_pointer:		rb 2
music_playing:		rb 1
music_timing:		rb 1
music_note_counter:	rb 1
music_instrument_1:	rb 1
music_counter_1:	rb 1
music_note_1:		rb 1
music_instrument_2:	rb 1
music_counter_2:	rb 1
music_note_2:		rb 1
music_instrument_3:	rb 1
music_counter_3:	rb 1
music_note_3:		rb 1
music_counter_4:	rb 1
music_drum:		rb 1

audio_freq1:		rb 2
audio_freq2:		rb 2
audio_freq3:		rb 2
audio_noise:		rb 1
audio_mix:		rb 1
audio_vol1:		rb 1
audio_vol2:		rb 1
audio_vol3:		rb 1

audio_control:		rb 1
audio_vol4hw:		rb 1
    endif
cvb_BOSS_COLOR:	rb 1
cvb_C:	rb 1
cvb_D:	rb 1
cvb_E:	rb 1
cvb_PLAYER_FRAME:	rb 1
cvb_LIVES:	rb 1
cvb_BOSS_FRAME:	rb 1
cvb_PLAYER_X:	rb 1
cvb_PLAYER_Y:	rb 1
cvb_SOUND_EFFECT:	rb 1
cvb_PLAYER_HIT:	rb 1
cvb_#SCORE:	rb 2
cvb_BOSS_HITS:	rb 1
cvb_#BX:	rb 2
cvb_#BY:	rb 2
cvb_SOUND_STATE:	rb 1
cvb_NEXT_ENEMY:	rb 1
cvb_BOSS_X:	rb 1
cvb_BOSS_Y:	rb 1
cvb_SCROLL_MAP:	rb 1
cvb_COUNT:	rb 1
cvb_SPR_FRAME:	rb 1
cvb_BOSS_DIR:	rb 1
cvb_#OFFSET:	rb 2
cvb_SPR_VDP:	rb 1
array_ENEMY_D:	rb 7
array_ENEMY_S:	rb 7
array_ENEMY_T:	rb 7
array_ENEMY_X:	rb 7
array_ENEMY_Y:	rb 7
